/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CloudFoundryProjectUtil {
    public static final String ID_MODULE_STANDALONE = "cloudfoundry.standalone.app";
    public static final String SPRING_NATURE_ID = "org.springframework.ide.eclipse.core.springnature";

    private CloudFoundryProjectUtil() {
    }

    public static boolean hasNature(IResource resource, String natureId) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature(natureId);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.log(e);
            }
        }
        return false;
    }

    public static boolean isSpringProject(IResource resource) {
        return CloudFoundryProjectUtil.hasNature(resource, SPRING_NATURE_ID);
    }

    public static boolean isJavaProject(IProject project) {
        return CloudFoundryProjectUtil.getJavaProject(project) != null;
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project == null) {
            return null;
        }
        if (project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError("Error getting Java project for project '" + project.getName() + "'", e);
            }
        }
        return null;
    }

    public static IProject getProject(CloudFoundryApplicationModule appModule) {
        IProject project = appModule.getLocalModule() != null ? appModule.getLocalModule().getProject() : null;
        return project != null && project.isAccessible() ? project : null;
    }

    public static IJavaProject getJavaProject(CloudFoundryApplicationModule appModule) {
        return CloudFoundryProjectUtil.getJavaProject(CloudFoundryProjectUtil.getProject(appModule));
    }

    public static boolean isSpringBootCloudFoundryConfigured(IProject project) {
        if (CloudFoundryProjectUtil.isSpringBoot(project)) {
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)ID_MODULE_STANDALONE);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject != null && facetedProject.hasProjectFacet(facet);
            }
            catch (CoreException e) {
                CloudFoundryPlugin.log(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSpringBoot(IProject project) {
        if (project == null) return false;
        if (!CloudFoundryProjectUtil.isSpringProject((IResource)project)) return false;
        try {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject(project);
            if (javaProject == null) return false;
            IClasspathEntry[] iClasspathEntryArray = classpath = javaProject.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (CloudFoundryProjectUtil.hasBootDependencies(e)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            CloudFoundryPlugin.logError(e);
        }
        return false;
    }

    public static boolean isSpringBoot(CloudFoundryApplicationModule appModule) {
        if (appModule == null) {
            return false;
        }
        return CloudFoundryProjectUtil.isSpringBoot(CloudFoundryProjectUtil.getProject(appModule));
    }

    private static boolean hasBootDependencies(IClasspathEntry e) {
        if (e.getEntryKind() == 1) {
            IPath path = e.getPath();
            String name = path.lastSegment();
            return name.endsWith(".jar") && name.startsWith("spring-boot");
        }
        return false;
    }
}

