/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.eclipse.cft.server.core.ArchiveEntry;

public abstract class AbstractArchiveEntry
implements ArchiveEntry {
    public static final int UNDEFINED_SIZE = -1;
    private static final int BUFFER_SIZE = 4096;
    private long size = -1L;
    private byte[] sha1Digest;

    protected void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        if (this.isDirectory()) {
            return 0L;
        }
        if (this.size == -1L) {
            this.deduceMissingData();
        }
        return this.size;
    }

    protected void setSha1Digest(byte[] sha1Digest) {
        this.sha1Digest = sha1Digest;
    }

    @Override
    public byte[] getSha1Digest() {
        if (this.isDirectory()) {
            return null;
        }
        if (this.sha1Digest == null) {
            this.deduceMissingData();
        }
        return this.sha1Digest;
    }

    private void deduceMissingData() {
        try (InputStream inputStream = this.getInputStream();){
            try {
                MessageDigest digest = this.sha1Digest == null ? MessageDigest.getInstance("SHA") : null;
                byte[] buffer = new byte[4096];
                int byteCount = 0;
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    byteCount += bytesRead;
                    if (digest == null) continue;
                    digest.update(buffer, 0, bytesRead);
                }
                if (this.size == -1L) {
                    this.size = byteCount;
                }
                if (this.sha1Digest == null && digest != null) {
                    this.sha1Digest = digest.digest();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

