/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.application.ICloudFoundryArchiver;
import org.eclipse.cft.server.core.internal.application.ManifestApplicationArchiver;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.application.WarApplicationArchiver;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class ApplicationArchiverFactory {
    public ICloudFoundryArchiver getWarApplicationArchiver() {
        return new WarApplicationArchiver();
    }

    public ICloudFoundryArchiver getManifestApplicationArchiver() {
        return new ManifestApplicationArchiver();
    }

    public boolean supportsManifestArchiving(IModule module, IServer server) {
        try {
            CloudFoundryApplicationModule appModule = CloudServerUtil.getCloudFoundryApplicationModule(module, server);
            CloudFoundryServer cloudServer = CloudServerUtil.getCloudServer(server);
            if (appModule != null && cloudServer != null) {
                ManifestParser parser = new ManifestParser(appModule, cloudServer);
                return parser.hasManifest();
            }
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
        return false;
    }
}

