/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class FrameworkProvider<T> {
    private static final String CLASS_ELEMENT = "class";
    private static final String PROVIDER_ID_ATTRIBUTE = "providerID";
    private T delegate;
    protected final IConfigurationElement configurationElement;
    private String providerID;
    private final String extensionPointID;

    protected FrameworkProvider(IConfigurationElement configurationElement, String extensionPointID) {
        this.configurationElement = configurationElement;
        this.extensionPointID = extensionPointID;
    }

    public String getProviderID() {
        if (this.providerID == null && this.configurationElement != null) {
            this.providerID = this.configurationElement.getAttribute(PROVIDER_ID_ATTRIBUTE);
        }
        return this.providerID;
    }

    public T getDelegate() {
        if (this.delegate == null && this.configurationElement != null) {
            try {
                Object object = this.configurationElement.createExecutableExtension(CLASS_ELEMENT);
                if (object == null) {
                    CloudFoundryPlugin.logError("No delegate class found. Must implement a delegate class. See extension point: " + this.extensionPointID + " for more details.");
                } else {
                    this.delegate = object;
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(e);
            }
        }
        return this.delegate;
    }
}

