/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.TargetURLDialog;
import org.eclipse.cft.server.ui.internal.UserDefinedCloudFoundryUrl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class CloudServerUIUtil {
    public static List<AbstractCloudFoundryUrl> getAllUrls(String serverTypeId, IRunnableContext runnableContext) throws CoreException {
        List<AbstractCloudFoundryUrl> cloudUrls;
        ArrayList<AbstractCloudFoundryUrl> urls = new ArrayList<AbstractCloudFoundryUrl>();
        AbstractCloudFoundryUrl defaultUrl = CloudServerUIUtil.getDefaultUrl(serverTypeId, runnableContext);
        if (defaultUrl != null) {
            urls.add(defaultUrl);
        }
        if ((cloudUrls = CloudServerUIUtil.getUrls(serverTypeId, runnableContext)) != null) {
            urls.addAll(cloudUrls);
        }
        return urls;
    }

    public static AbstractCloudFoundryUrl getDefaultUrl(final String serverTypeId, IRunnableContext context) throws CoreException {
        try {
            final AbstractCloudFoundryUrl[] abstractUrls = new AbstractCloudFoundryUrl[1];
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    abstractUrls[0] = CloudFoundryBrandingExtensionPoint.getDefaultUrl((String)serverTypeId);
                }
            };
            if (context != null) {
                CloudUiUtil.runForked(coreRunner, context);
            } else {
                CloudUiUtil.runForked(coreRunner);
            }
            return abstractUrls[0];
        }
        catch (OperationCanceledException e) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus((Throwable)e));
        }
    }

    public static List<AbstractCloudFoundryUrl> getUrls(final String serverTypeId, IRunnableContext context) throws CoreException {
        try {
            final ArrayList<AbstractCloudFoundryUrl> cloudUrls = new ArrayList<AbstractCloudFoundryUrl>();
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    HashSet<String> urlNames = new HashSet<String>();
                    List<AbstractCloudFoundryUrl> userDefinedUrls = CloudServerUIUtil.getUserDefinedUrls(serverTypeId);
                    for (AbstractCloudFoundryUrl userDefinedUrl : userDefinedUrls) {
                        cloudUrls.add(userDefinedUrl);
                        urlNames.add(userDefinedUrl.getName());
                    }
                    List defaultUrls = CloudFoundryBrandingExtensionPoint.getCloudUrls((String)serverTypeId);
                    if (defaultUrls != null) {
                        for (AbstractCloudFoundryUrl defaultUrl : defaultUrls) {
                            if (urlNames.contains(defaultUrl.getName())) continue;
                            cloudUrls.add(defaultUrl);
                        }
                        Collections.sort(cloudUrls, new Comparator<AbstractCloudFoundryUrl>(){

                            @Override
                            public int compare(AbstractCloudFoundryUrl o1, AbstractCloudFoundryUrl o2) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                        });
                    }
                }
            };
            if (context != null) {
                CloudUiUtil.runForked(coreRunner, context);
            } else {
                CloudUiUtil.runForked(coreRunner);
            }
            return cloudUrls;
        }
        catch (OperationCanceledException e) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus((Throwable)e));
        }
    }

    public static AbstractCloudFoundryUrl getWildcardUrl(AbstractCloudFoundryUrl cloudUrl, List<AbstractCloudFoundryUrl> allCloudUrls, Shell shell) {
        String url = cloudUrl.getUrl();
        if (url.contains("{")) {
            int endIndex;
            int startIndex = url.indexOf("{");
            String wildcard = url.substring(startIndex + 1, endIndex = url.indexOf("}"));
            TargetURLDialog dialog = new TargetURLDialog(shell, cloudUrl, wildcard, allCloudUrls);
            if (dialog.open() == 0) {
                url = dialog.getUrl();
                String name = dialog.getName();
                boolean selfSigned = url != null && CloudFoundryServer.getSelfSignedCertificate((String)url);
                return new UserDefinedCloudFoundryUrl(name, url, selfSigned);
            }
            return null;
        }
        return null;
    }

    public static List<AbstractCloudFoundryUrl> getUserDefinedUrls(String serverTypeId) {
        String[] urlEntries;
        ArrayList<AbstractCloudFoundryUrl> urls = new ArrayList<AbstractCloudFoundryUrl>();
        IPreferenceStore prefStore = CloudFoundryServerUiPlugin.getDefault().getPreferenceStore();
        String urlString = prefStore.getString(String.valueOf(CloudUiUtil.ATTR_USER_DEFINED_URLS) + "." + serverTypeId);
        if (urlString != null && urlString.length() > 0 && (urlEntries = urlString.split("\\|\\|")) != null) {
            String[] stringArray = urlEntries;
            int n = urlEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String[] values;
                String entry = stringArray[n2];
                if (entry.length() > 0 && (values = entry.split(",")) != null) {
                    String name = null;
                    String url = null;
                    if (values.length >= 2) {
                        name = values[0];
                        url = values[1];
                    }
                    boolean selfSigned = url != null && CloudFoundryServer.getSelfSignedCertificate(url);
                    urls.add(new UserDefinedCloudFoundryUrl(name, url, selfSigned));
                }
                ++n2;
            }
        }
        return urls;
    }

    public static void storeUserDefinedUrls(String serverTypeId, List<AbstractCloudFoundryUrl> urls) {
        IPreferenceStore prefStore = CloudFoundryServerUiPlugin.getDefault().getPreferenceStore();
        StringBuilder builder = new StringBuilder();
        for (AbstractCloudFoundryUrl url : urls) {
            if (!url.getUserDefined()) continue;
            builder.append(url.getName());
            builder.append(",");
            builder.append(url.getUrl());
            builder.append("||");
            CloudFoundryServer.setSelfSignedCertificate((boolean)url.getSelfSigned(), (String)url.getUrl());
        }
        prefStore.setValue(String.valueOf(CloudUiUtil.ATTR_USER_DEFINED_URLS) + "." + serverTypeId, builder.toString());
    }
}

