/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.ServiceToApplicationsBindingPart;
import org.eclipse.cft.server.ui.internal.actions.AddServicesToApplicationAction;
import org.eclipse.cft.server.ui.internal.actions.RemoveServicesFromApplicationAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.editor.ServicesHandler;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ServiceToApplicationsBindingWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private ServiceToApplicationsBindingWizardPage bindServiceToApplicationPage;
    private ServicesHandler servicesHandler;
    private final CloudFoundryApplicationsEditorPage editorPage;

    public ServiceToApplicationsBindingWizard(ServicesHandler servicesHandler, CloudFoundryServer server, CloudFoundryApplicationsEditorPage editorPage) {
        this.cloudServer = server;
        this.servicesHandler = servicesHandler;
        this.editorPage = editorPage;
        this.setWindowTitle(server.getServer().getName());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.bindServiceToApplicationPage = new ServiceToApplicationsBindingWizardPage(this.servicesHandler, this.cloudServer, this.editorPage);
        this.bindServiceToApplicationPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.bindServiceToApplicationPage);
    }

    public boolean performFinish() {
        this.bindServiceToApplicationPage.performFinish();
        return true;
    }

    static class ServiceToApplicationsBindingWizardPage
    extends PartsWizardPage {
        private ServiceToApplicationsBindingPart serviceToApplicationsBindingPart;
        private final CloudFoundryServer server;
        ServicesHandler servicesHandler;
        CloudFoundryApplicationsEditorPage editorPage;

        public ServiceToApplicationsBindingWizardPage(ServicesHandler servicesHandler, CloudFoundryServer server, CloudFoundryApplicationsEditorPage editorPage) {
            super(Messages.MANAGE_SERVICES_TO_APPLICATIONS_TITLE, Messages.MANAGE_SERVICES_TO_APPLICATIONS_TITLE, CloudFoundryImages.getWizardBanner(server.getServer().getServerType().getId()));
            this.setDescription(NLS.bind((String)Messages.MANAGE_SERVICES_TO_APPLICATIONS_DESCRIPTION, (Object)servicesHandler.toString()));
            this.server = server;
            this.servicesHandler = servicesHandler;
            this.editorPage = editorPage;
        }

        @Override
        public void performWhenPageVisible() {
            this.runAsynchWithWizardProgress(new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    CloudFoundryServerBehaviour behaviour;
                    if (ServiceToApplicationsBindingWizardPage.this.server != null && (behaviour = ServiceToApplicationsBindingWizardPage.this.server.getBehaviour()) != null) {
                        monitor.beginTask(Messages.MANAGE_SERVICES_TO_APPLICATIONS_GET_APPLICATION_NAMES, -1);
                        final List allApps = behaviour.getApplications(monitor);
                        monitor.done();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ServiceToApplicationsBindingWizardPage.this.serviceToApplicationsBindingPart.setInput(allApps);
                            }
                        });
                    }
                }
            }, Messages.MANAGE_SERVICES_TO_APPLICATIONS_TITLE);
        }

        @Override
        public boolean isPageComplete() {
            return true;
        }

        protected void performFinish() {
            block4: {
                try {
                    CloudUiUtil.runForked(new ICoreRunnable(){

                        @Override
                        public void run(IProgressMonitor monitor) throws CoreException {
                            monitor.setTaskName(Messages.MANAGE_SERVICES_TO_APPLICATIONS_FINISH);
                            CloudFoundryServerBehaviour behaviour = ServiceToApplicationsBindingWizardPage.this.server.getBehaviour();
                            if (ServiceToApplicationsBindingWizardPage.this.serviceToApplicationsBindingPart != null && ServiceToApplicationsBindingWizardPage.this.server != null && behaviour != null) {
                                List<ServiceToApplicationsBindingPart.ApplicationToService> applicationsToProcess = ServiceToApplicationsBindingWizardPage.this.serviceToApplicationsBindingPart.getApplicationToService();
                                CloudService cloudService = null;
                                try {
                                    List cloudServiceList = behaviour.getServices(monitor);
                                    int lenCloudService = cloudServiceList.size();
                                    String serviceName = ServiceToApplicationsBindingWizardPage.this.servicesHandler.toString();
                                    int j = 0;
                                    while (j < lenCloudService) {
                                        String currServiceName;
                                        CloudService currService = (CloudService)cloudServiceList.get(j);
                                        if (currService != null && (currServiceName = currService.getName()) != null && currServiceName.equals(serviceName)) {
                                            cloudService = currService;
                                            break;
                                        }
                                        ++j;
                                    }
                                    StructuredSelection structuredSelection = new StructuredSelection(cloudService);
                                    int len = applicationsToProcess.size();
                                    int i = 0;
                                    while (i < len) {
                                        ServiceToApplicationsBindingPart.ApplicationToService curr = applicationsToProcess.get(i);
                                        boolean isBoundToServiceAfter = curr.getBoundToServiceAfter();
                                        if (isBoundToServiceAfter != curr.getBoundToServiceBefore()) {
                                            CloudApplication cloudApp = applicationsToProcess.get(i).getCloudApplication();
                                            CloudFoundryApplicationModule module = ServiceToApplicationsBindingWizardPage.this.server.getExistingCloudModule(cloudApp.getName());
                                            if (isBoundToServiceAfter) {
                                                AddServicesToApplicationAction bindService = new AddServicesToApplicationAction((IStructuredSelection)structuredSelection, module, ServiceToApplicationsBindingWizardPage.this.server.getBehaviour(), ServiceToApplicationsBindingWizardPage.this.editorPage);
                                                bindService.run();
                                            } else {
                                                RemoveServicesFromApplicationAction unbindService = new RemoveServicesFromApplicationAction((IStructuredSelection)structuredSelection, module, ServiceToApplicationsBindingWizardPage.this.server.getBehaviour(), ServiceToApplicationsBindingWizardPage.this.editorPage);
                                                unbindService.run();
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                catch (CoreException e) {
                                    if (Logger.ERROR) {
                                        Logger.println("/debug/error", this, "performFinish", "Error when processing applications to bind or unbind with the service", (Throwable)e);
                                    }
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.MANAGE_SERVICES_TO_APPLICATIONS_FINISH_ERROR_TITLE, (String)Messages.MANAGE_SERVICES_TO_APPLICATIONS_FINISH_ERROR_DESCRIPTION);
                                        }
                                    });
                                }
                            }
                        }
                    }, (IRunnableContext)this.getWizard().getContainer());
                }
                catch (OperationCanceledException e1) {
                    if (Logger.ERROR) {
                        Logger.println("/debug/error", this, "performFinish", "Error when processing applications to bind or unbind with the service", (Throwable)e1);
                    }
                }
                catch (CoreException e1) {
                    if (!Logger.ERROR) break block4;
                    Logger.println("/debug/error", this, "performFinish", "Error when processing applications to bind or unbind with the service", (Throwable)e1);
                }
            }
        }

        public void createControl(Composite parent) {
            this.serviceToApplicationsBindingPart = new ServiceToApplicationsBindingPart(this.servicesHandler);
            this.serviceToApplicationsBindingPart.addPartChangeListener(this);
            Control control = this.serviceToApplicationsBindingPart.createPart(parent);
            this.setControl(control);
        }

        @Override
        public void handleChange(PartChangeEvent event) {
        }
    }
}

