/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.Staging;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.wst.server.core.IModule;

public class StandaloneModuleHelper {
    private final CloudFoundryApplicationModule appModule;
    private final IModule module;

    public StandaloneModuleHelper(CloudFoundryApplicationModule appModule) {
        this.appModule = appModule;
        this.module = appModule.getLocalModule();
    }

    public StandaloneModuleHelper(IModule module) {
        this.appModule = null;
        this.module = module;
    }

    public boolean isSupportedStandalone() {
        if (this.appModule == null && this.module == null) {
            return false;
        }
        boolean isStandalone = this.module != null && "cloudfoundry.standalone.app".equals(this.module.getModuleType().getId());
        return isStandalone;
    }

    public Staging getStaging() {
        CloudApplication cloudApp;
        Staging staging;
        if (this.appModule == null) {
            return null;
        }
        Staging staging2 = staging = this.appModule.getDeploymentInfo() != null ? this.appModule.getDeploymentInfo().getStaging() : null;
        if (staging == null && (cloudApp = this.appModule.getApplication()) != null) {
            staging = cloudApp.getStaging();
        }
        return staging;
    }
}

