/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.IURLProvider2;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class CloudFoundryLaunchable
extends HttpLaunchable {
    public CloudFoundryLaunchable(final IServer server, final IModuleArtifact moduleObject) {
        super(new IURLProvider2(){

            public URL getModuleRootURL(IModule module) {
                IURLProvider urlProvider = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
                return urlProvider.getModuleRootURL(module);
            }

            public URL getLaunchableURL() {
                URL url;
                block11: {
                    try {
                        url = this.getModuleRootURL(moduleObject.getModule());
                        if (url != null) break block11;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                if (moduleObject instanceof Servlet) {
                    Servlet servlet = (Servlet)moduleObject;
                    if (servlet.getAlias() != null) {
                        String path = servlet.getAlias();
                        if (path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        url = new URL(url, path);
                    } else {
                        url = new URL(url, "servlet/" + servlet.getServletClassName());
                    }
                } else if (moduleObject instanceof WebResource) {
                    WebResource resource = (WebResource)moduleObject;
                    String path = resource.getPath().toString();
                    if (path != null && path.startsWith("/") && path.length() > 0) {
                        path = path.substring(1);
                    }
                    if (path != null && path.length() > 0) {
                        url = new URL(url, path);
                    }
                }
                final URL url2 = url;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.waitForUrlAvaiable(url2, 10000L);
                    }
                });
                return url;
            }

            private boolean waitForUrlAvaiable(URL moduleUrl, long timeout) {
                HttpURLConnection conn = null;
                int code = -1;
                long interval = timeout / 20L;
                int i = 0;
                while (i < 20) {
                    try {
                        conn = (HttpURLConnection)moduleUrl.openConnection();
                        conn.setUseCaches(false);
                        conn.setRequestMethod("GET");
                        conn.setReadTimeout(5000);
                        conn.connect();
                        code = conn.getResponseCode();
                        if (code != 404) {
                            return true;
                        }
                    }
                    catch (Throwable throwable) {}
                    if (conn != null) {
                        conn.disconnect();
                        conn = null;
                    }
                    try {
                        Thread.sleep(interval);
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                return false;
            }
        });
    }
}

