/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.osgi.framework.Bundle;

public class ReflectionHandler {
    private ReflectionErrorHandler errorHandler;

    public void addErrorHandler(ReflectionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Method getRemotingProject(Class<?> providerClass) {
        String methodName = "getRemotingProject";
        Exception t = null;
        Method method = null;
        try {
            method = providerClass.getMethod(methodName, IProject.class);
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (SecurityException e) {
            t = e;
        }
        if (method == null) {
            this.handleError(methodName, providerClass.getName(), t);
        }
        return method;
    }

    public Method getAddServerUrlMethod(Class<?> integrationClass) {
        String methodName = "addServer";
        Exception t = null;
        Method method = null;
        try {
            method = integrationClass.getDeclaredMethod(methodName, URI.class, String.class);
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (SecurityException e) {
            t = e;
        }
        if (method == null) {
            this.handleError(methodName, integrationClass.getName(), t);
        }
        return method;
    }

    public Method getRemoveServerUrlMethod(Class<?> integrationClass) {
        String methodName = "removeServer";
        Exception t = null;
        Method method = null;
        try {
            method = integrationClass.getDeclaredMethod(methodName, URI.class);
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (SecurityException e) {
            t = e;
        }
        if (method == null) {
            this.handleError(methodName, integrationClass.getName(), t);
        }
        return method;
    }

    public Class<?> getRebelRemotingProvider(Bundle bundle) {
        Class providerClass = null;
        String className = "org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider";
        Throwable t = null;
        try {
            providerClass = bundle.loadClass(className);
        }
        catch (Throwable e) {
            t = e;
        }
        if (providerClass == null) {
            this.handleError(className, bundle.getSymbolicName(), t);
        }
        return providerClass;
    }

    public Class<?> getJRebelIntegration(Bundle bundle) {
        Class providerClass = null;
        String className = "org.zeroturnaround.eclipse.api.JRebelIntegration";
        Throwable t = null;
        try {
            providerClass = bundle.loadClass(className);
        }
        catch (Throwable e) {
            t = e;
        }
        if (providerClass == null) {
            this.handleError(className, bundle.getSymbolicName(), t);
        }
        return providerClass;
    }

    protected void handleError(String memberId, String containerId, Throwable t) {
        if (this.errorHandler != null) {
            this.errorHandler.errorLoading(memberId, containerId, t);
        }
    }

    public boolean addServerUrl(Method addServerUrlsMethod, Map<String, URI> serverUrls) {
        block4: {
            if (serverUrls != null && !serverUrls.isEmpty()) {
                Throwable t = null;
                try {
                    addServerUrlsMethod.setAccessible(true);
                    for (Map.Entry<String, URI> entry : serverUrls.entrySet()) {
                        addServerUrlsMethod.invoke(null, entry.getValue(), entry.getKey());
                    }
                    return true;
                }
                catch (Throwable e) {
                    t = e;
                    if (t == null) break block4;
                    this.handleError(addServerUrlsMethod.getName(), addServerUrlsMethod.getDeclaringClass().getName(), t);
                }
            }
        }
        return false;
    }

    public boolean removeServerUrl(Method removeServerUrlMethod, List<URI> uris) {
        block4: {
            if (uris != null && !uris.isEmpty()) {
                Throwable t = null;
                try {
                    removeServerUrlMethod.setAccessible(true);
                    for (URI uri : uris) {
                        removeServerUrlMethod.invoke(null, uri);
                    }
                    return true;
                }
                catch (Throwable e) {
                    t = e;
                    if (t == null) break block4;
                    this.handleError(removeServerUrlMethod.getName(), removeServerUrlMethod.getDeclaringClass().getName(), t);
                }
            }
        }
        return false;
    }

    public static interface ReflectionErrorHandler {
        public void errorLoading(String var1, String var2, Throwable var3);
    }
}

