/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.AppUrlChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelConsoleUtil;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelServerUrlHandler;
import org.eclipse.cft.server.core.internal.jrebel.CloudRebelServerUrlHandler;
import org.eclipse.cft.server.core.internal.jrebel.JRebelIntegrationUtility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class CFRebelServerIntegration
implements CloudServerListener {
    private final CFRebelServerUrlHandler[] HANDLER_REGISTRY = new CFRebelServerUrlHandler[]{new CloudRebelServerUrlHandler()};

    public abstract void register();

    @Override
    public void serverChanged(CloudServerEvent event) {
        if (event.getServer() != null && (event.getType() == 700 || JRebelIntegrationUtility.shouldReplaceRemotingUrl(event.getType()))) {
            ModuleChangeEvent moduleEvent;
            IModule module;
            ArrayList<IModule> modules = new ArrayList<IModule>();
            if (event instanceof ModuleChangeEvent && (module = (moduleEvent = (ModuleChangeEvent)event).getModule()) != null) {
                modules.add(module);
            }
            if (!modules.isEmpty()) {
                this.updateModulesWithRebelProjects(modules, event);
            }
        }
    }

    protected void updateModulesWithRebelProjects(List<IModule> modules, CloudServerEvent event) {
        Iterator<IModule> iterator = modules.iterator();
        while (iterator.hasNext()) {
            CloudFoundryServer cloudServer;
            IModule module;
            final IModule mod = module = iterator.next();
            final CloudServerEvent moduleEvent = event;
            CloudFoundryServer cloudFoundryServer = cloudServer = event != null ? event.getServer() : null;
            if (!JRebelIntegrationUtility.isJRebelEnabled(module, cloudServer)) continue;
            final String consoleMessage = NLS.bind((String)Messages.CFRebelServerIntegration_UPDATING_JREBEL_REMOTING, (Object)module.getName());
            Job job = new Job(consoleMessage){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CFRebelServerIntegration.this.handleRebelProject(moduleEvent, mod, consoleMessage, monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError(e);
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected void handleRebelProject(CloudServerEvent event, IModule module, String consoleMessage, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = event.getServer();
        if (consoleMessage != null) {
            CFRebelConsoleUtil.printToConsole(module, cloudServer, consoleMessage);
        }
        int eventType = event.getType();
        List<String> oldUrls = null;
        List<String> currentUrls = null;
        if (event instanceof AppUrlChangeEvent) {
            AppUrlChangeEvent appUrlEvent = (AppUrlChangeEvent)event;
            oldUrls = appUrlEvent.getOldUrls();
            currentUrls = appUrlEvent.getCurrentUrls();
        } else {
            CloudFoundryApplicationModule cloudAppModule = cloudServer.getExistingCloudModule(module);
            if (cloudAppModule != null) {
                CFRebelConsoleUtil.printToConsole(cloudAppModule, cloudServer, Messages.CFRebelServerIntegration_UPDATING_APP_MODULE);
                cloudAppModule = cloudServer.getBehaviour().updateDeployedModule(module, monitor);
                CFRebelConsoleUtil.printToConsole(cloudAppModule, cloudServer, Messages.CFRebelServerIntegration_UPDATED_APP_MODULE);
                if (cloudAppModule != null && cloudAppModule.getDeploymentInfo() != null) {
                    currentUrls = cloudAppModule.getDeploymentInfo().getUris();
                }
            }
            if (cloudAppModule == null) {
                String errorMessage = "Unable to update JRebel server URL for  " + module.getName() + ". No cloud application module found.  Please refresh the Cloud server instance " + cloudServer.getServer().getId() + " and try again.";
                CloudFoundryPlugin.logError(errorMessage);
                return;
            }
        }
        this.updateUrls(cloudServer, eventType, module, oldUrls, currentUrls, monitor);
    }

    private void updateUrls(CloudFoundryServer cloudServer, int eventType, IModule module, List<String> oldUrls, List<String> currentUrls, IProgressMonitor monitor) {
        CFRebelServerUrlHandler[] registry;
        CFRebelServerUrlHandler[] cFRebelServerUrlHandlerArray = registry = this.getServerUrlRegistry();
        int n = registry.length;
        int n2 = 0;
        while (n2 < n) {
            CFRebelServerUrlHandler handler = cFRebelServerUrlHandlerArray[n2];
            if (handler.updateUrls(cloudServer, eventType, module, oldUrls, currentUrls, monitor)) break;
            ++n2;
        }
    }

    protected CFRebelServerUrlHandler[] getServerUrlRegistry() {
        return this.HANDLER_REGISTRY;
    }
}

