/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;

public class ShowConsoleEditorAction
extends Action {
    private final CloudFoundryServer server;
    private final CloudFoundryApplicationModule appModule;
    private final int instanceIndex;

    public ShowConsoleEditorAction(CloudFoundryServer server, CloudFoundryApplicationModule appModule, int instanceIndex) {
        this.server = server;
        this.appModule = appModule;
        this.instanceIndex = instanceIndex;
        this.setText(Messages.ShowConsoleEditorAction_TEXT_SHOW_CONSOLE);
    }

    public ShowConsoleEditorAction(CloudFoundryServer server, CloudFoundryApplicationModule appModule) {
        this(server, appModule, 0);
    }

    public void run() {
        Job job = new Job(Messages.SHOWING_CONSOLE){

            public IStatus run(IProgressMonitor monitor) {
                if (CloudFoundryPlugin.getCallback() != null) {
                    CloudFoundryPlugin.getCallback().stopApplicationConsole(ShowConsoleEditorAction.this.appModule, ShowConsoleEditorAction.this.server);
                    CloudFoundryPlugin.getCallback().printToConsole(ShowConsoleEditorAction.this.server, ShowConsoleEditorAction.this.appModule, Messages.SHOWING_CONSOLE, true, false);
                    CloudFoundryPlugin.getCallback().showCloudFoundryLogs(ShowConsoleEditorAction.this.server, ShowConsoleEditorAction.this.appModule, ShowConsoleEditorAction.this.instanceIndex, monitor);
                    return Status.OK_STATUS;
                }
                return CloudFoundryPlugin.getErrorStatus((String)"Internal Error: No Cloud Foundry console callback available. Unable to refresh console contents.");
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

