/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.LinkedHashMap;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.client.AbstractPublishApplicationOperation;
import org.eclipse.cft.server.core.internal.client.ApplicationUpdateOperation;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.CloudRefreshEvent;
import org.eclipse.cft.server.core.internal.client.DeleteModulesOperation;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.core.internal.client.PushApplicationOperation;
import org.eclipse.cft.server.core.internal.client.RestartOperation;
import org.eclipse.cft.server.core.internal.client.StartOperation;
import org.eclipse.cft.server.core.internal.client.StopApplicationOperation;
import org.eclipse.cft.server.core.internal.client.UpdateServicesOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;

public class CloudBehaviourOperations {
    public static String INTERNAL_ERROR_NO_WST_MODULE = "Internal Error: No WST IModule specified - Unable to deploy or start application";
    private final CloudFoundryServerBehaviour behaviour;

    public CloudBehaviourOperations(CloudFoundryServerBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public ICloudFoundryOperation createServices(CloudService[] services) throws CoreException {
        return new UpdateServicesOperation(this.behaviour.getRequestFactory().getCreateServicesRequest(services), this.behaviour);
    }

    public ICloudFoundryOperation deleteServices(List<String> services) throws CoreException {
        return new UpdateServicesOperation(this.behaviour.getRequestFactory().getDeleteServicesRequest(services), this.behaviour);
    }

    public ICloudFoundryOperation instancesUpdate(final CloudFoundryApplicationModule appModule, final int instanceCount) throws CoreException {
        return new BehaviourOperation(this.behaviour, appModule.getLocalModule()){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                String appName = appModule.getDeployedApplicationName();
                this.getBehaviour().updateApplicationInstances(appName, instanceCount, monitor);
                this.getBehaviour().updateCloudModuleWithInstances(appModule.getLocalModule(), monitor);
                ServerEventHandler.getDefault().fireAppInstancesChanged(CloudBehaviourOperations.this.behaviour.getCloudFoundryServer(), this.getModule());
                this.getBehaviour().getRefreshHandler().schedulesRefreshApplication(this.getModule());
            }
        };
    }

    public ICloudFoundryOperation memoryUpdate(CloudFoundryApplicationModule appModule, int memory) throws CoreException {
        return new ApplicationUpdateOperation(this.behaviour.getRequestFactory().getUpdateApplicationMemoryRequest(appModule, memory), this.behaviour, appModule);
    }

    public ICloudFoundryOperation mappedUrlsUpdate(String appName, List<String> urls) throws CoreException {
        CloudFoundryApplicationModule appModule = this.behaviour.getCloudFoundryServer().getExistingCloudModule(appName);
        if (appModule != null) {
            return new ApplicationUpdateOperation(this.behaviour.getRequestFactory().getUpdateAppUrlsRequest(appName, urls), this.behaviour, appModule.getLocalModule());
        }
        throw CloudErrorUtil.toCoreException("Expected an existing Cloud application module but found none. Unable to update application URLs");
    }

    public ICloudFoundryOperation bindServices(CloudFoundryApplicationModule appModule, List<String> services) throws CoreException {
        return new ApplicationUpdateOperation(this.behaviour.getRequestFactory().getUpdateServicesRequest(appModule.getDeployedApplicationName(), services), this.behaviour, appModule.getLocalModule());
    }

    public ICloudFoundryOperation environmentVariablesUpdate(IModule module, String appName, List<EnvironmentVariable> variables) throws CoreException {
        BaseClientRequest<Void> request = this.behaviour.getRequestFactory().getUpdateEnvVarRequest(appName, variables);
        return new ApplicationUpdateOperation(request, this.behaviour, module);
    }

    public ICloudFoundryOperation applicationDeployment(CloudFoundryApplicationModule application, ApplicationAction action) throws CoreException {
        IModule[] modules = new IModule[]{application.getLocalModule()};
        return this.applicationDeployment(modules, action, true);
    }

    public ICloudFoundryOperation applicationDeployment(IModule[] modules, ApplicationAction action) throws CoreException {
        return this.applicationDeployment(modules, action, true);
    }

    public ICloudFoundryOperation applicationDeployment(IModule[] modules, ApplicationAction action, boolean clearConsole) throws CoreException {
        if (modules == null || modules.length == 0) {
            throw CloudErrorUtil.toCoreException(INTERNAL_ERROR_NO_WST_MODULE);
        }
        AbstractPublishApplicationOperation operation = null;
        switch (action) {
            case START: {
                boolean incrementalPublish = false;
                operation = new StartOperation(this.behaviour, incrementalPublish, modules, clearConsole);
                break;
            }
            case STOP: {
                operation = new StopApplicationOperation(this.behaviour, modules);
                break;
            }
            case RESTART: {
                operation = new RestartOperation(this.behaviour, modules, clearConsole);
                break;
            }
            case UPDATE_RESTART: {
                operation = new StartOperation(this.behaviour, CloudFoundryPlugin.getDefault().getIncrementalPublish(), modules, clearConsole);
                break;
            }
            case PUSH: {
                operation = new PushApplicationOperation(this.behaviour, modules, clearConsole);
            }
        }
        if (operation == null) {
            throw CloudErrorUtil.toCoreException("Internal Error: Unable to resolve a Cloud application operation.");
        }
        return operation;
    }

    public BehaviourOperation refreshAll(IModule module) {
        return new BehaviourOperation(this.behaviour, module){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                subMonitor.beginTask(NLS.bind((String)Messages.CloudBehaviourOperations_REFRESHING_APPS_AND_SERVICES, (Object)cloudServer.getServer().getId()), 100);
                if (this.getModule() != null) {
                    this.getBehaviour().updateCloudModuleWithInstances(this.getModule(), (IProgressMonitor)subMonitor.newChild(40));
                } else {
                    subMonitor.worked(40);
                }
                List<CloudApplication> applications = this.getBehaviour().getApplications((IProgressMonitor)subMonitor.newChild(20));
                LinkedHashMap<String, CloudApplication> deployedApplicationsByName = new LinkedHashMap<String, CloudApplication>();
                for (CloudApplication application : applications) {
                    deployedApplicationsByName.put(application.getName(), application);
                }
                cloudServer.updateModules(deployedApplicationsByName);
                Server server = (Server)cloudServer.getServer();
                IModule[] iModuleArray = server.getModules();
                int n = iModuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule module = iModuleArray[n2];
                    CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
                    if (appModule != null) {
                        appModule.setStatus(null);
                        appModule.validateDeploymentInfo();
                    }
                    ++n2;
                }
                List<CloudService> services = this.getBehaviour().getServices((IProgressMonitor)subMonitor.newChild(20));
                ServerEventHandler.getDefault().fireServerEvent(new CloudRefreshEvent(this.getBehaviour().getCloudFoundryServer(), this.getModule(), 400, services));
                subMonitor.worked(20);
            }
        };
    }

    public BehaviourOperation refreshForDeploymentChange(final IModule module) {
        return new BehaviourOperation(this.behaviour, module){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                if (module == null) {
                    throw CloudErrorUtil.toCoreException("Internal Error: No module to refresh in - " + this.getBehaviour().getCloudFoundryServer().getServerId());
                }
                this.getBehaviour().updateCloudModuleWithInstances(module, monitor);
                ServerEventHandler.getDefault().fireAppDeploymentChanged(CloudBehaviourOperations.this.behaviour.getCloudFoundryServer(), module);
            }
        };
    }

    public BehaviourOperation refreshApplication(final IModule module) {
        return new BehaviourOperation(this.behaviour, module){

            @Override
            public void run(IProgressMonitor monitor) throws CoreException {
                if (module == null) {
                    throw CloudErrorUtil.toCoreException("Internal Error: No module to refresh in - " + this.getBehaviour().getCloudFoundryServer().getServerId());
                }
                CloudFoundryApplicationModule appModule = this.getBehaviour().updateCloudModuleWithInstances(module, monitor);
                if (appModule != null) {
                    appModule.setStatus(null);
                    appModule.validateDeploymentInfo();
                }
                ServerEventHandler.getDefault().fireApplicationRefreshed(CloudBehaviourOperations.this.behaviour.getCloudFoundryServer(), module);
            }
        };
    }

    public ICloudFoundryOperation deleteModules(IModule[] modules, boolean deleteServices) {
        return new DeleteModulesOperation(this.behaviour, modules, deleteServices);
    }
}

