/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.ssh;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.eclipse.cft.server.core.internal.client.AuthorizationHeaderProvider;
import org.eclipse.cft.server.core.internal.client.RestUtils;
import org.eclipse.cft.server.core.internal.ssh.CloudInfoV2;
import org.eclipse.cft.server.core.internal.ssh.SshHost;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.RestTemplate;

public class SshClientSupport {
    private AuthorizationHeaderProvider oauth;
    private RestTemplate restTemplate;
    private CloudInfoV2 cloudInfo;
    private String authorizationUrl;
    private String sshClientId;

    public SshClientSupport(AuthorizationHeaderProvider oauth, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        this.cloudInfo = cloudInfo;
        this.oauth = oauth;
        this.restTemplate = RestUtils.createRestTemplate(httpProxyConfiguration, trustSelfSigned, true);
        ClientHttpRequestFactory requestFactory = this.restTemplate.getRequestFactory();
        this.restTemplate.setRequestFactory(this.authorize(requestFactory));
        this.authorizationUrl = cloudInfo.getAuthorizationUrl();
        this.sshClientId = cloudInfo.getSshClientId();
    }

    private ClientHttpRequestFactory authorize(final ClientHttpRequestFactory delegate) {
        return new ClientHttpRequestFactory(){

            public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
                ClientHttpRequest request = delegate.createRequest(uri, httpMethod);
                request.getHeaders().add("Authorization", SshClientSupport.this.oauth.getAuthorizationHeader());
                return request;
            }
        };
    }

    public String getSshCode() {
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(this.authorizationUrl) + "/oauth/authorize");
            builder.addParameter("response_type", "code");
            builder.addParameter("grant_type", "authorization_code");
            builder.addParameter("client_id", this.sshClientId);
            URI url = new URI(builder.toString());
            ResponseEntity response = this.restTemplate.getForEntity(url, String.class);
            HttpStatus statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.FOUND) {
                throw new CloudFoundryException(statusCode);
            }
            String loc = response.getHeaders().getFirst("Location");
            if (loc == null) {
                throw new CloudOperationException("No 'Location' header in redirect response");
            }
            List qparams = URLEncodedUtils.parse((URI)new URI(loc), (String)"utf8");
            for (NameValuePair pair : qparams) {
                String name = pair.getName();
                if (!name.equals("code")) continue;
                return pair.getValue();
            }
            throw new CloudOperationException("No 'code' param in redirect Location: " + loc);
        }
        catch (URISyntaxException e) {
            throw new CloudOperationException((Throwable)e);
        }
    }

    public SshHost getSshHost() {
        return this.cloudInfo.getSshHost();
    }

    public static SshClientSupport create(final CloudFoundryOperations client, CloudCredentials creds, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        AuthorizationHeaderProvider oauth = new AuthorizationHeaderProvider(){

            @Override
            public String getAuthorizationHeader() {
                OAuth2AccessToken token = client.login();
                return String.valueOf(token.getTokenType()) + " " + token.getValue();
            }
        };
        CloudInfoV2 cloudInfo = new CloudInfoV2(creds, client.getCloudControllerUrl(), proxyConf, selfSigned);
        return new SshClientSupport(oauth, cloudInfo, selfSigned, proxyConf);
    }
}

