/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class RefreshModulesHandler {
    private BehaviourRefreshJob refreshJob;
    private final CloudFoundryServer cloudServer;
    private BehaviourOperation opToRun;
    private static final String NO_SERVER_ERROR = "Null server in refresh module handler. Unable to schedule module refresh.";

    public RefreshModulesHandler(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        String serverName = cloudServer != null ? cloudServer.getServer().getId() : "Unknown server";
        String refreshJobLabel = NLS.bind((String)Messages.RefreshModulesHandler_REFRESH_JOB, (Object)serverName);
        this.refreshJob = new BehaviourRefreshJob(refreshJobLabel);
    }

    public synchronized void scheduleRefreshAll() {
        if (this.cloudServer == null) {
            CloudFoundryPlugin.logError(NO_SERVER_ERROR);
        } else if (this.opToRun == null) {
            this.scheduleRefresh(this.cloudServer.getBehaviour().operations().refreshAll(null));
        }
    }

    public synchronized boolean isScheduled() {
        return this.opToRun != null;
    }

    public synchronized void scheduleRefreshAll(IModule module) {
        if (this.cloudServer == null) {
            CloudFoundryPlugin.logError(NO_SERVER_ERROR);
        } else if (this.opToRun == null) {
            this.scheduleRefresh(this.cloudServer.getBehaviour().operations().refreshAll(module));
        }
    }

    public synchronized void schedulesRefreshApplication(IModule module) {
        if (this.cloudServer == null) {
            CloudFoundryPlugin.logError(NO_SERVER_ERROR);
        } else if (this.opToRun == null) {
            this.scheduleRefresh(this.cloudServer.getBehaviour().operations().refreshApplication(module));
        }
    }

    public synchronized void scheduleRefreshForDeploymentChange(IModule module) {
        if (this.cloudServer == null) {
            CloudFoundryPlugin.logError(NO_SERVER_ERROR);
        } else if (this.opToRun == null) {
            this.scheduleRefresh(this.cloudServer.getBehaviour().operations().refreshForDeploymentChange(module));
        }
    }

    private synchronized void scheduleRefresh(BehaviourOperation opToRun) {
        if (this.opToRun == null) {
            this.opToRun = opToRun;
            this.schedule();
        }
    }

    private void schedule() {
        this.refreshJob.setSystem(false);
        this.refreshJob.schedule();
    }

    private class BehaviourRefreshJob
    extends Job {
        public BehaviourRefreshJob(String label) {
            super(label);
        }

        public IStatus run(IProgressMonitor monitor) {
            block8: {
                try {
                    CloudFoundryServer cloudServer = null;
                    IModule module = RefreshModulesHandler.this.opToRun.getModule();
                    try {
                        cloudServer = RefreshModulesHandler.this.opToRun.getBehaviour() != null ? RefreshModulesHandler.this.opToRun.getBehaviour().getCloudFoundryServer() : null;
                    }
                    catch (CoreException ce) {
                        CloudFoundryPlugin.logError(ce);
                    }
                    try {
                        RefreshModulesHandler.this.opToRun.run(monitor);
                    }
                    catch (Throwable t) {
                        if (cloudServer == null) {
                            CloudFoundryPlugin.logError(NLS.bind((String)Messages.RefreshModulesHandler_EVENT_CLOUD_SERVER_NULL, RefreshModulesHandler.this.opToRun.getClass()));
                            break block8;
                        }
                        ServerEventHandler.getDefault().fireError(cloudServer, module, CloudFoundryPlugin.getErrorStatus(Messages.RefreshModulesHandler_REFRESH_FAILURE, t));
                    }
                }
                finally {
                    RefreshModulesHandler.this.opToRun = null;
                }
            }
            return Status.OK_STATUS;
        }
    }
}

