/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class DSCompiler {
    private static AtomicReference<DSCompiler[][]> compilers = new AtomicReference<Object>(null);
    private final int parameters;
    private final int order;
    private final int[][] sizes;
    private final int[][] derivativesIndirection;
    private final int[] lowerIndirection;
    private final int[][][] multIndirection;
    private final int[][][] compIndirection;

    private DSCompiler(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) throws NumberIsTooLargeException {
        this.parameters = parameters;
        this.order = order;
        this.sizes = DSCompiler.compileSizes(parameters, order, valueCompiler);
        this.derivativesIndirection = DSCompiler.compileDerivativesIndirection(parameters, order, valueCompiler, derivativeCompiler);
        this.lowerIndirection = DSCompiler.compileLowerIndirection(parameters, order, valueCompiler, derivativeCompiler);
        this.multIndirection = DSCompiler.compileMultiplicationIndirection(parameters, order, valueCompiler, derivativeCompiler, this.lowerIndirection);
        this.compIndirection = DSCompiler.compileCompositionIndirection(parameters, order, valueCompiler, derivativeCompiler, this.sizes, this.derivativesIndirection);
    }

    public static DSCompiler getCompiler(int parameters, int order) throws NumberIsTooLargeException {
        DSCompiler[][] cache = compilers.get();
        if (cache != null && cache.length > parameters && cache[parameters].length > order && cache[parameters][order] != null) {
            return cache[parameters][order];
        }
        int maxParameters = FastMath.max(parameters, cache == null ? 0 : cache.length);
        int maxOrder = FastMath.max(order, cache == null ? 0 : cache[0].length);
        DSCompiler[][] newCache = new DSCompiler[maxParameters + 1][maxOrder + 1];
        if (cache != null) {
            int i = 0;
            while (i < cache.length) {
                System.arraycopy(cache[i], 0, newCache[i], 0, cache[i].length);
                ++i;
            }
        }
        int diag = 0;
        while (diag <= parameters + order) {
            int o = FastMath.max(0, diag - parameters);
            while (o <= FastMath.min(order, diag)) {
                int p = diag - o;
                if (newCache[p][o] == null) {
                    DSCompiler valueCompiler = p == 0 ? null : newCache[p - 1][o];
                    DSCompiler derivativeCompiler = o == 0 ? null : newCache[p][o - 1];
                    newCache[p][o] = new DSCompiler(p, o, valueCompiler, derivativeCompiler);
                }
                ++o;
            }
            ++diag;
        }
        compilers.compareAndSet(cache, newCache);
        return newCache[parameters][order];
    }

    private static int[][] compileSizes(int parameters, int order, DSCompiler valueCompiler) {
        int[][] sizes = new int[parameters + 1][order + 1];
        if (parameters == 0) {
            Arrays.fill(sizes[0], 1);
        } else {
            System.arraycopy(valueCompiler.sizes, 0, sizes, 0, parameters);
            sizes[parameters][0] = 1;
            int i = 0;
            while (i < order) {
                sizes[parameters][i + 1] = sizes[parameters][i] + sizes[parameters - 1][i + 1];
                ++i;
            }
        }
        return sizes;
    }

    private static int[][] compileDerivativesIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) {
        if (parameters == 0 || order == 0) {
            return new int[1][parameters];
        }
        int vSize = valueCompiler.derivativesIndirection.length;
        int dSize = derivativeCompiler.derivativesIndirection.length;
        int[][] derivativesIndirection = new int[vSize + dSize][parameters];
        int i = 0;
        while (i < vSize) {
            System.arraycopy(valueCompiler.derivativesIndirection[i], 0, derivativesIndirection[i], 0, parameters - 1);
            ++i;
        }
        i = 0;
        while (i < dSize) {
            System.arraycopy(derivativeCompiler.derivativesIndirection[i], 0, derivativesIndirection[vSize + i], 0, parameters);
            int[] nArray = derivativesIndirection[vSize + i];
            int n = parameters - 1;
            nArray[n] = nArray[n] + 1;
            ++i;
        }
        return derivativesIndirection;
    }

    private static int[] compileLowerIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler) {
        if (parameters == 0 || order <= 1) {
            return new int[1];
        }
        int vSize = valueCompiler.lowerIndirection.length;
        int dSize = derivativeCompiler.lowerIndirection.length;
        int[] lowerIndirection = new int[vSize + dSize];
        System.arraycopy(valueCompiler.lowerIndirection, 0, lowerIndirection, 0, vSize);
        int i = 0;
        while (i < dSize) {
            lowerIndirection[vSize + i] = valueCompiler.getSize() + derivativeCompiler.lowerIndirection[i];
            ++i;
        }
        return lowerIndirection;
    }

    private static int[][][] compileMultiplicationIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler, int[] lowerIndirection) {
        if (parameters == 0 || order == 0) {
            int[][][] nArrayArray = new int[1][][];
            int[][] nArrayArray2 = new int[1][];
            int[] nArray = new int[3];
            nArray[0] = 1;
            nArrayArray2[0] = nArray;
            nArrayArray[0] = nArrayArray2;
            return nArrayArray;
        }
        int vSize = valueCompiler.multIndirection.length;
        int dSize = derivativeCompiler.multIndirection.length;
        int[][][] multIndirection = new int[vSize + dSize][][];
        System.arraycopy(valueCompiler.multIndirection, 0, multIndirection, 0, vSize);
        int i = 0;
        while (i < dSize) {
            int[][] dRow = derivativeCompiler.multIndirection[i];
            ArrayList<int[]> row = new ArrayList<int[]>(dRow.length * 2);
            int j = 0;
            while (j < dRow.length) {
                row.add(new int[]{dRow[j][0], lowerIndirection[dRow[j][1]], vSize + dRow[j][2]});
                row.add(new int[]{dRow[j][0], vSize + dRow[j][1], lowerIndirection[dRow[j][2]]});
                ++j;
            }
            ArrayList<int[]> combined = new ArrayList<int[]>(row.size());
            int j2 = 0;
            while (j2 < row.size()) {
                int[] termJ = (int[])row.get(j2);
                if (termJ[0] > 0) {
                    int k = j2 + 1;
                    while (k < row.size()) {
                        int[] termK = (int[])row.get(k);
                        if (termJ[1] == termK[1] && termJ[2] == termK[2]) {
                            termJ[0] = termJ[0] + termK[0];
                            termK[0] = 0;
                        }
                        ++k;
                    }
                    combined.add(termJ);
                }
                ++j2;
            }
            multIndirection[vSize + i] = (int[][])combined.toArray((T[])new int[combined.size()][]);
            ++i;
        }
        return multIndirection;
    }

    private static int[][][] compileCompositionIndirection(int parameters, int order, DSCompiler valueCompiler, DSCompiler derivativeCompiler, int[][] sizes, int[][] derivativesIndirection) throws NumberIsTooLargeException {
        if (parameters == 0 || order == 0) {
            int[][][] nArrayArray = new int[1][][];
            int[][] nArrayArray2 = new int[1][];
            int[] nArray = new int[2];
            nArray[0] = 1;
            nArrayArray2[0] = nArray;
            nArrayArray[0] = nArrayArray2;
            return nArrayArray;
        }
        int vSize = valueCompiler.compIndirection.length;
        int dSize = derivativeCompiler.compIndirection.length;
        int[][][] compIndirection = new int[vSize + dSize][][];
        System.arraycopy(valueCompiler.compIndirection, 0, compIndirection, 0, vSize);
        int i = 0;
        while (i < dSize) {
            int l;
            ArrayList<int[]> row = new ArrayList<int[]>();
            int[][] nArray = derivativeCompiler.compIndirection[i];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int[] term = nArray[n2];
                int[] derivedTermF = new int[term.length + 1];
                derivedTermF[0] = term[0];
                derivedTermF[1] = term[1] + 1;
                int[] orders = new int[parameters];
                orders[parameters - 1] = 1;
                derivedTermF[term.length] = DSCompiler.getPartialDerivativeIndex(parameters, order, sizes, orders);
                int j = 2;
                while (j < term.length) {
                    derivedTermF[j] = DSCompiler.convertIndex(term[j], parameters, derivativeCompiler.derivativesIndirection, parameters, order, sizes);
                    ++j;
                }
                Arrays.sort(derivedTermF, 2, derivedTermF.length);
                row.add(derivedTermF);
                l = 2;
                while (l < term.length) {
                    int[] derivedTermG = new int[term.length];
                    derivedTermG[0] = term[0];
                    derivedTermG[1] = term[1];
                    int j2 = 2;
                    while (j2 < term.length) {
                        derivedTermG[j2] = DSCompiler.convertIndex(term[j2], parameters, derivativeCompiler.derivativesIndirection, parameters, order, sizes);
                        if (j2 == l) {
                            System.arraycopy(derivativesIndirection[derivedTermG[j2]], 0, orders, 0, parameters);
                            int n3 = parameters - 1;
                            orders[n3] = orders[n3] + 1;
                            derivedTermG[j2] = DSCompiler.getPartialDerivativeIndex(parameters, order, sizes, orders);
                        }
                        ++j2;
                    }
                    Arrays.sort(derivedTermG, 2, derivedTermG.length);
                    row.add(derivedTermG);
                    ++l;
                }
                ++n2;
            }
            ArrayList<int[]> combined = new ArrayList<int[]>(row.size());
            int j = 0;
            while (j < row.size()) {
                int[] termJ = (int[])row.get(j);
                if (termJ[0] > 0) {
                    int k = j + 1;
                    while (k < row.size()) {
                        int[] termK = (int[])row.get(k);
                        boolean equals = termJ.length == termK.length;
                        l = 1;
                        while (equals && l < termJ.length) {
                            equals &= termJ[l] == termK[l];
                            ++l;
                        }
                        if (equals) {
                            termJ[0] = termJ[0] + termK[0];
                            termK[0] = 0;
                        }
                        ++k;
                    }
                    combined.add(termJ);
                }
                ++j;
            }
            compIndirection[vSize + i] = (int[][])combined.toArray((T[])new int[combined.size()][]);
            ++i;
        }
        return compIndirection;
    }

    public int getPartialDerivativeIndex(int ... orders) throws DimensionMismatchException, NumberIsTooLargeException {
        if (orders.length != this.getFreeParameters()) {
            throw new DimensionMismatchException(orders.length, this.getFreeParameters());
        }
        return DSCompiler.getPartialDerivativeIndex(this.parameters, this.order, this.sizes, orders);
    }

    /*
     * Unable to fully structure code
     */
    private static int getPartialDerivativeIndex(int parameters, int order, int[][] sizes, int ... orders) throws NumberIsTooLargeException {
        index = 0;
        m = order;
        ordersSum = 0;
        i = parameters - 1;
        while (i >= 0) {
            derivativeOrder = orders[i];
            if ((ordersSum += derivativeOrder) <= order) ** GOTO lbl10
            throw new NumberIsTooLargeException(ordersSum, (Number)order, true);
lbl-1000:
            // 1 sources

            {
                index += sizes[i][m--];
lbl10:
                // 2 sources

                ** while (derivativeOrder-- > 0)
            }
lbl11:
            // 1 sources

            --i;
        }
        return index;
    }

    private static int convertIndex(int index, int srcP, int[][] srcDerivativesIndirection, int destP, int destO, int[][] destSizes) throws NumberIsTooLargeException {
        int[] orders = new int[destP];
        System.arraycopy(srcDerivativesIndirection[index], 0, orders, 0, FastMath.min(srcP, destP));
        return DSCompiler.getPartialDerivativeIndex(destP, destO, destSizes, orders);
    }

    public int[] getPartialDerivativeOrders(int index) {
        return this.derivativesIndirection[index];
    }

    public int getFreeParameters() {
        return this.parameters;
    }

    public int getOrder() {
        return this.order;
    }

    public int getSize() {
        return this.sizes[this.parameters][this.order];
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.getSize()) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i]);
            ++i;
        }
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double a3, double[] c3, int offset3, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.getSize()) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i]);
            ++i;
        }
    }

    public void linearCombination(double a1, double[] c1, int offset1, double a2, double[] c2, int offset2, double a3, double[] c3, int offset3, double a4, double[] c4, int offset4, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.getSize()) {
            result[resultOffset + i] = MathArrays.linearCombination(a1, c1[offset1 + i], a2, c2[offset2 + i], a3, c3[offset3 + i], a4, c4[offset4 + i]);
            ++i;
        }
    }

    public void add(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.getSize()) {
            result[resultOffset + i] = lhs[lhsOffset + i] + rhs[rhsOffset + i];
            ++i;
        }
    }

    public void subtract(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.getSize()) {
            result[resultOffset + i] = lhs[lhsOffset + i] - rhs[rhsOffset + i];
            ++i;
        }
    }

    public void multiply(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.multIndirection.length) {
            int[][] mappingI = this.multIndirection[i];
            double r = 0.0;
            int j = 0;
            while (j < mappingI.length) {
                r += (double)mappingI[j][0] * lhs[lhsOffset + mappingI[j][1]] * rhs[rhsOffset + mappingI[j][2]];
                ++j;
            }
            result[resultOffset + i] = r;
            ++i;
        }
    }

    public void divide(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        double[] reciprocal = new double[this.getSize()];
        this.pow(rhs, lhsOffset, -1, reciprocal, 0);
        this.multiply(lhs, lhsOffset, reciprocal, 0, result, resultOffset);
    }

    public void remainder(double[] lhs, int lhsOffset, double[] rhs, int rhsOffset, double[] result, int resultOffset) {
        double rem = FastMath.IEEEremainder(lhs[lhsOffset], rhs[rhsOffset]);
        double k = FastMath.rint((lhs[lhsOffset] - rem) / rhs[rhsOffset]);
        result[resultOffset] = rem;
        int i = 1;
        while (i < this.getSize()) {
            result[resultOffset + i] = lhs[lhsOffset + i] - k * rhs[rhsOffset + i];
            ++i;
        }
    }

    public void pow(double a, double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        if (a == 0.0) {
            if (operand[operandOffset] == 0.0) {
                function[0] = 1.0;
                double infinity = Double.POSITIVE_INFINITY;
                int i = 1;
                while (i < function.length) {
                    function[i] = infinity = -infinity;
                    ++i;
                }
            } else if (operand[operandOffset] < 0.0) {
                Arrays.fill(function, Double.NaN);
            }
        } else {
            function[0] = FastMath.pow(a, operand[operandOffset]);
            double lnA = FastMath.log(a);
            int i = 1;
            while (i < function.length) {
                function[i] = lnA * function[i - 1];
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void pow(double[] operand, int operandOffset, double p, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double xk = FastMath.pow(operand[operandOffset], p - (double)this.order);
        int i = this.order;
        while (i > 0) {
            function[i] = xk;
            xk *= operand[operandOffset];
            --i;
        }
        function[0] = xk;
        double coefficient = p;
        int i2 = 1;
        while (i2 <= this.order) {
            int n = i2;
            function[n] = function[n] * coefficient;
            coefficient *= p - (double)i2;
            ++i2;
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void pow(double[] operand, int operandOffset, int n, double[] result, int resultOffset) {
        if (n == 0) {
            result[resultOffset] = 1.0;
            Arrays.fill(result, resultOffset + 1, resultOffset + this.getSize(), 0.0);
            return;
        }
        double[] function = new double[1 + this.order];
        if (n > 0) {
            int maxOrder = FastMath.min(this.order, n);
            double xk = FastMath.pow(operand[operandOffset], n - maxOrder);
            int i = maxOrder;
            while (i > 0) {
                function[i] = xk;
                xk *= operand[operandOffset];
                --i;
            }
            function[0] = xk;
        } else {
            double inv = 1.0 / operand[operandOffset];
            double xk = FastMath.pow(inv, -n);
            int i = 0;
            while (i <= this.order) {
                function[i] = xk;
                xk *= inv;
                ++i;
            }
        }
        double coefficient = n;
        int i = 1;
        while (i <= this.order) {
            int n2 = i;
            function[n2] = function[n2] * coefficient;
            coefficient *= (double)(n - i);
            ++i;
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void pow(double[] x, int xOffset, double[] y, int yOffset, double[] result, int resultOffset) {
        double[] logX = new double[this.getSize()];
        this.log(x, xOffset, logX, 0);
        double[] yLogX = new double[this.getSize()];
        this.multiply(logX, 0, y, yOffset, yLogX, 0);
        this.exp(yLogX, 0, result, resultOffset);
    }

    public void rootN(double[] operand, int operandOffset, int n, double[] result, int resultOffset) {
        double xk;
        double[] function = new double[1 + this.order];
        if (n == 2) {
            function[0] = FastMath.sqrt(operand[operandOffset]);
            xk = 0.5 / function[0];
        } else if (n == 3) {
            function[0] = FastMath.cbrt(operand[operandOffset]);
            xk = 1.0 / (3.0 * function[0] * function[0]);
        } else {
            function[0] = FastMath.pow(operand[operandOffset], 1.0 / (double)n);
            xk = 1.0 / ((double)n * FastMath.pow(function[0], n - 1));
        }
        double nReciprocal = 1.0 / (double)n;
        double xReciprocal = 1.0 / operand[operandOffset];
        int i = 1;
        while (i <= this.order) {
            function[i] = xk;
            xk *= xReciprocal * (nReciprocal - (double)i);
            ++i;
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void exp(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        Arrays.fill(function, FastMath.exp(operand[operandOffset]));
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void expm1(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.expm1(operand[operandOffset]);
        Arrays.fill(function, 1, 1 + this.order, FastMath.exp(operand[operandOffset]));
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void log(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log(operand[operandOffset]);
        if (this.order > 0) {
            double inv;
            double xk = inv = 1.0 / operand[operandOffset];
            int i = 1;
            while (i <= this.order) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void log1p(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log1p(operand[operandOffset]);
        if (this.order > 0) {
            double inv;
            double xk = inv = 1.0 / (1.0 + operand[operandOffset]);
            int i = 1;
            while (i <= this.order) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void log10(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.log10(operand[operandOffset]);
        if (this.order > 0) {
            double inv = 1.0 / operand[operandOffset];
            double xk = inv / FastMath.log(10.0);
            int i = 1;
            while (i <= this.order) {
                function[i] = xk;
                xk *= (double)(-i) * inv;
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void cos(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.cos(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = -FastMath.sin(operand[operandOffset]);
            int i = 2;
            while (i <= this.order) {
                function[i] = -function[i - 2];
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void sin(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.sin(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = FastMath.cos(operand[operandOffset]);
            int i = 2;
            while (i <= this.order) {
                function[i] = -function[i - 2];
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void tan(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double t;
        double[] function = new double[1 + this.order];
        function[0] = t = FastMath.tan(operand[operandOffset]);
        if (this.order > 0) {
            double[] p = new double[this.order + 2];
            p[1] = 1.0;
            double t2 = t * t;
            int n = 1;
            while (n <= this.order) {
                double v = 0.0;
                p[n + 1] = (double)n * p[n];
                int k = n + 1;
                while (k >= 0) {
                    v = v * t2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(k - 3) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= t;
                }
                function[n] = v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void acos(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.acos(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = -1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 - x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                p[n - 1] = (double)(n - 1) * p[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(2 * n - k) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void asin(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.asin(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 - x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                p[n - 1] = (double)(n - 1) * p[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(2 * n - k) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void atan(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.atan(x);
        if (this.order > 0) {
            double f;
            double[] q = new double[this.order];
            q[0] = 1.0;
            double x2 = x * x;
            double coeff = f = 1.0 / (1.0 + x2);
            function[1] = coeff * q[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                q[n - 1] = (double)(-n) * q[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + q[k];
                    if (k > 2) {
                        q[k - 2] = (double)(k - 1) * q[k - 1] + (double)(k - 1 - 2 * n) * q[k - 3];
                    } else if (k == 2) {
                        q[0] = q[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void atan2(double[] y, int yOffset, double[] x, int xOffset, double[] result, int resultOffset) {
        double[] tmp1 = new double[this.getSize()];
        this.multiply(x, xOffset, x, xOffset, tmp1, 0);
        double[] tmp2 = new double[this.getSize()];
        this.multiply(y, yOffset, y, yOffset, tmp2, 0);
        this.add(tmp1, 0, tmp2, 0, tmp2, 0);
        this.rootN(tmp2, 0, 2, tmp1, 0);
        if (x[xOffset] >= 0.0) {
            this.add(tmp1, 0, x, xOffset, tmp2, 0);
            this.divide(y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            int i = 0;
            while (i < tmp2.length) {
                result[resultOffset + i] = 2.0 * tmp2[i];
                ++i;
            }
        } else {
            this.subtract(tmp1, 0, x, xOffset, tmp2, 0);
            this.divide(y, yOffset, tmp2, 0, tmp1, 0);
            this.atan(tmp1, 0, tmp2, 0);
            result[resultOffset] = (tmp2[0] <= 0.0 ? -Math.PI : Math.PI) - 2.0 * tmp2[0];
            int i = 1;
            while (i < tmp2.length) {
                result[resultOffset + i] = -2.0 * tmp2[i];
                ++i;
            }
        }
        result[resultOffset] = FastMath.atan2(y[yOffset], x[xOffset]);
    }

    public void cosh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.cosh(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = FastMath.sinh(operand[operandOffset]);
            int i = 2;
            while (i <= this.order) {
                function[i] = function[i - 2];
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void sinh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        function[0] = FastMath.sinh(operand[operandOffset]);
        if (this.order > 0) {
            function[1] = FastMath.cosh(operand[operandOffset]);
            int i = 2;
            while (i <= this.order) {
                function[i] = function[i - 2];
                ++i;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void tanh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double t;
        double[] function = new double[1 + this.order];
        function[0] = t = FastMath.tanh(operand[operandOffset]);
        if (this.order > 0) {
            double[] p = new double[this.order + 2];
            p[1] = 1.0;
            double t2 = t * t;
            int n = 1;
            while (n <= this.order) {
                double v = 0.0;
                p[n + 1] = (double)(-n) * p[n];
                int k = n + 1;
                while (k >= 0) {
                    v = v * t2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] - (double)(k - 3) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= t;
                }
                function[n] = v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void acosh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.acosh(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (x2 - 1.0);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                p[n - 1] = (double)(1 - n) * p[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(1 - k) * p[k - 1] + (double)(k - 2 * n) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = -p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void asinh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.asinh(x);
        if (this.order > 0) {
            double[] p = new double[this.order];
            p[0] = 1.0;
            double x2 = x * x;
            double f = 1.0 / (1.0 + x2);
            double coeff = FastMath.sqrt(f);
            function[1] = coeff * p[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                p[n - 1] = (double)(1 - n) * p[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + p[k];
                    if (k > 2) {
                        p[k - 2] = (double)(k - 1) * p[k - 1] + (double)(k - 2 * n) * p[k - 3];
                    } else if (k == 2) {
                        p[0] = p[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void atanh(double[] operand, int operandOffset, double[] result, int resultOffset) {
        double[] function = new double[1 + this.order];
        double x = operand[operandOffset];
        function[0] = FastMath.atanh(x);
        if (this.order > 0) {
            double f;
            double[] q = new double[this.order];
            q[0] = 1.0;
            double x2 = x * x;
            double coeff = f = 1.0 / (1.0 - x2);
            function[1] = coeff * q[0];
            int n = 2;
            while (n <= this.order) {
                double v = 0.0;
                q[n - 1] = (double)n * q[n - 2];
                int k = n - 1;
                while (k >= 0) {
                    v = v * x2 + q[k];
                    if (k > 2) {
                        q[k - 2] = (double)(k - 1) * q[k - 1] + (double)(2 * n - k + 1) * q[k - 3];
                    } else if (k == 2) {
                        q[0] = q[1];
                    }
                    k -= 2;
                }
                if ((n & 1) == 0) {
                    v *= x;
                }
                function[n] = (coeff *= f) * v;
                ++n;
            }
        }
        this.compose(operand, operandOffset, function, result, resultOffset);
    }

    public void compose(double[] operand, int operandOffset, double[] f, double[] result, int resultOffset) {
        int i = 0;
        while (i < this.compIndirection.length) {
            int[][] mappingI = this.compIndirection[i];
            double r = 0.0;
            int j = 0;
            while (j < mappingI.length) {
                int[] mappingIJ = mappingI[j];
                double product = (double)mappingIJ[0] * f[mappingIJ[1]];
                int k = 2;
                while (k < mappingIJ.length) {
                    product *= operand[operandOffset + mappingIJ[k]];
                    ++k;
                }
                r += product;
                ++j;
            }
            result[resultOffset + i] = r;
            ++i;
        }
    }

    public double taylor(double[] ds, int dsOffset, double ... delta) throws MathArithmeticException {
        double value = 0.0;
        int i = this.getSize() - 1;
        while (i >= 0) {
            int[] orders = this.getPartialDerivativeOrders(i);
            double term = ds[dsOffset + i];
            int k = 0;
            while (k < orders.length) {
                if (orders[k] > 0) {
                    try {
                        term *= FastMath.pow(delta[k], orders[k]) / (double)CombinatoricsUtils.factorial(orders[k]);
                    }
                    catch (NotPositiveException e) {
                        throw new MathInternalError(e);
                    }
                }
                ++k;
            }
            value += term;
            --i;
        }
        return value;
    }

    public void checkCompatibility(DSCompiler compiler) throws DimensionMismatchException {
        if (this.parameters != compiler.parameters) {
            throw new DimensionMismatchException(this.parameters, compiler.parameters);
        }
        if (this.order != compiler.order) {
            throw new DimensionMismatchException(this.order, compiler.order);
        }
    }
}

