/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.primes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.primes.SmallPrimes;
import org.apache.commons.math3.util.FastMath;

class PollardRho {
    private PollardRho() {
    }

    public static List<Integer> primeFactors(int n) {
        ArrayList<Integer> factors = new ArrayList<Integer>();
        if (1 == (n = SmallPrimes.smallTrialDivision(n, factors))) {
            return factors;
        }
        if (SmallPrimes.millerRabinPrimeTest(n)) {
            factors.add(n);
            return factors;
        }
        int divisor = PollardRho.rhoBrent(n);
        factors.add(divisor);
        factors.add(n / divisor);
        return factors;
    }

    static int rhoBrent(int n) {
        int cst = SmallPrimes.PRIMES_LAST;
        int y = 2;
        int r = 1;
        while (true) {
            int x = y;
            int i = 0;
            while (i < r) {
                long y2 = (long)y * (long)y;
                y = (int)((y2 + (long)cst) % (long)n);
                ++i;
            }
            int k = 0;
            do {
                int bound = FastMath.min(25, r - k);
                int q = 1;
                int i2 = -3;
                while (i2 < bound) {
                    long y2 = (long)y * (long)y;
                    long divisor = FastMath.abs(x - (y = (int)((y2 + (long)cst) % (long)n)));
                    if (0L == divisor) {
                        cst += SmallPrimes.PRIMES_LAST;
                        k = -25;
                        y = 2;
                        r = 1;
                        break;
                    }
                    long prod = divisor * (long)q;
                    if ((q = (int)(prod % (long)n)) == 0) {
                        return PollardRho.gcdPositive(FastMath.abs((int)divisor), n);
                    }
                    ++i2;
                }
                int out = PollardRho.gcdPositive(FastMath.abs(q), n);
                if (1 == out) continue;
                return out;
            } while ((k += 25) < r);
            r *= 2;
        }
    }

    static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = FastMath.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = FastMath.min(a, b);
            a = FastMath.abs(delta);
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }
}

