/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.progress.ui.internal.core;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.progress.core.IStatusLineMessageListener;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.ui.exceptions.DisplayException;
import org.eclipse.chemclipse.progress.ui.exceptions.StatusLineManagerException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIStatusLineLogger
implements IStatusLineMessageListener {
    private static final Logger logger = Logger.getLogger(UIStatusLineLogger.class);
    private IStatusLineManager statusLineManager;
    private Display display;

    public void setInfo(final InfoType infoType, final String message) {
        try {
            final IStatusLineManager statusLineManager = this.getStatusLineManager();
            Display display = this.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    switch (infoType) {
                        case MESSAGE: {
                            statusLineManager.setMessage(message);
                            break;
                        }
                        case ERROR_MESSAGE: {
                            statusLineManager.setErrorMessage(message);
                        }
                    }
                }
            });
        }
        catch (StatusLineManagerException statusLineManagerException) {
        }
        catch (DisplayException e) {
            logger.warn((Object)e);
        }
    }

    private Display getDisplay() throws DisplayException {
        if (this.display == null) {
            this.display = Display.getCurrent();
            if (this.display == null) {
                throw new DisplayException("The display instance is null.");
            }
        }
        return this.display;
    }

    private IStatusLineManager getStatusLineManager() throws StatusLineManagerException {
        if (this.statusLineManager == null) {
            IWorkbenchWindow workbenchWindow = this.getWorkbenchWindow();
            IWorkbenchPage workbenchPage = this.getWorkbenchPage(workbenchWindow);
            IWorkbenchPart workbenchPart = this.getWorkbenchPart(workbenchPage);
            IActionBars actionBars = this.getActionBars(workbenchPart.getSite());
            this.statusLineManager = this.getStatusLineManager(actionBars);
        }
        return this.statusLineManager;
    }

    private IStatusLineManager getStatusLineManager(IActionBars actionBars) throws StatusLineManagerException {
        if (actionBars != null) {
            return actionBars.getStatusLineManager();
        }
        throw new StatusLineManagerException("IActionBars instance is not available.");
    }

    private IWorkbenchWindow getWorkbenchWindow() throws StatusLineManagerException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            throw new StatusLineManagerException("IWorkbenchWindow instance is not available.");
        }
        return workbenchWindow;
    }

    private IWorkbenchPage getWorkbenchPage(IWorkbenchWindow workbenchWindow) throws StatusLineManagerException {
        assert (workbenchWindow != null) : "The workbenchWindow instance must not be null.";
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        if (workbenchPage == null) {
            throw new StatusLineManagerException("IWorkbenchPage instance is not available.");
        }
        return workbenchPage;
    }

    private IWorkbenchPart getWorkbenchPart(IWorkbenchPage workbenchPage) throws StatusLineManagerException {
        assert (workbenchPage != null) : "The workbenchPage instance must not be null.";
        IWorkbenchPart workbenchPart = workbenchPage.getActivePart();
        if (workbenchPart == null) {
            throw new StatusLineManagerException("IWorkbenchPart instance is not available.");
        }
        return workbenchPart;
    }

    private IActionBars getActionBars(IWorkbenchPartSite workbenchPartSite) throws StatusLineManagerException {
        if (workbenchPartSite instanceof IViewSite) {
            IViewSite viewSite = (IViewSite)workbenchPartSite;
            IActionBars actionBars = viewSite.getActionBars();
            return actionBars;
        }
        if (workbenchPartSite instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)workbenchPartSite;
            IActionBars actionBars = editorSite.getActionBars();
            return actionBars;
        }
        throw new StatusLineManagerException("IViewSite or IEditorSite instances are not available.");
    }
}

