/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.BatchProcessJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class BatchProcessImportRunnable
implements IRunnableWithProgress {
    private File file;
    private IBatchProcessJob batchProcessJob = null;

    public BatchProcessImportRunnable(File file) {
        this.file = file;
    }

    public IBatchProcessJob getBatchProcessJob() {
        return this.batchProcessJob;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        BatchProcessJobReader reader = new BatchProcessJobReader();
        try {
            this.batchProcessJob = reader.read(this.file, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InterruptedException("The file " + this.file.getPath() + " couldn't be found.");
        }
        catch (FileIsNotReadableException fileIsNotReadableException) {
            throw new InterruptedException("The file " + this.file.getPath() + " is not readable.");
        }
        catch (FileIsEmptyException fileIsEmptyException) {
            throw new InterruptedException("The file " + this.file.getPath() + " is empty.");
        }
        catch (IOException iOException) {
            throw new InterruptedException("An I/O error has occured using the file " + this.file.getPath());
        }
    }
}

