/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.wizards;

import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReportSupport;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.ChromatogramReports;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.exceptions.NoReportSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.ChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.IChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChromatogramReportEntriesWizardPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(ChromatogramReportEntriesWizardPage.class);
    private Combo chromatogramReportSupplierComboBox;
    private Text chromatogramReportFolderOrFileTextBox;
    private ChromatogramReportSupport reportSupport;
    private boolean appendReports = false;
    private Button buttonSelectFileOrFolder;
    private Label label;

    protected ChromatogramReportEntriesWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Chromatogram Report Supplier");
        this.setDescription("This wizard lets you select several chromatogram report supplier.");
    }

    public IChromatogramReportSupplierEntry getChromatogramReportEntry() throws NoReportSupplierAvailableException {
        IChromatogramReportSupplier reportSupplier = this.getReportSupplier();
        String reportSupplierId = reportSupplier.getId();
        String reportFolderOrFile = this.chromatogramReportFolderOrFileTextBox.getText();
        if (reportFolderOrFile == null || reportFolderOrFile.equals("")) {
            throw new NoReportSupplierAvailableException("The report folder/file must not be null.");
        }
        return new ChromatogramReportSupplierEntry(reportFolderOrFile, reportSupplierId);
    }

    private IChromatogramReportSupplier getReportSupplier() throws NoReportSupplierAvailableException {
        int index = this.chromatogramReportSupplierComboBox.getSelectionIndex();
        if (index >= 0) {
            String description = this.chromatogramReportSupplierComboBox.getItem(index);
            String reportSupplierId = this.reportSupport.getReportSupplierId(description);
            return this.reportSupport.getReportSupplier(reportSupplierId);
        }
        throw new NoReportSupplierAvailableException("No report supplier has been selected.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.reportSupport = ChromatogramReports.getChromatogramReportSupplierSupport();
        try {
            Label labelx = new Label(composite, 0);
            labelx.setText("Select the chromatogram report supplier:");
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            labelx.setLayoutData((Object)gridData);
            String[] filterNames = this.reportSupport.getFilterNames();
            this.chromatogramReportSupplierComboBox = new Combo(composite, 0);
            this.chromatogramReportSupplierComboBox.setItems(filterNames);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            this.chromatogramReportSupplierComboBox.setLayoutData((Object)gridData);
            final Button appendReportButton = new Button(composite, 32);
            appendReportButton.setText("Append the chromatogram reports to a distinct file");
            appendReportButton.setSelection(this.appendReports);
            gridData = new GridData(768);
            gridData.verticalIndent = 20;
            gridData.horizontalSpan = 2;
            appendReportButton.setLayoutData((Object)gridData);
            appendReportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChromatogramReportEntriesWizardPage.this.appendReports = appendReportButton.getSelection();
                    ChromatogramReportEntriesWizardPage.this.buttonSelectFileOrFolder.setText(ChromatogramReportEntriesWizardPage.this.appendReports ? "Select report file" : "Select report folder");
                    ChromatogramReportEntriesWizardPage.this.label.setText(ChromatogramReportEntriesWizardPage.this.appendReports ? "Chromatogram report file" : "Chromatogram report folder");
                }
            });
            this.label = new Label(composite, 0);
            this.label.setText(this.appendReports ? "Chromatogram report file" : "Chromatogram report folder");
            gridData = new GridData(768);
            gridData.verticalIndent = 20;
            gridData.horizontalSpan = 2;
            this.label.setLayoutData((Object)gridData);
            this.chromatogramReportFolderOrFileTextBox = new Text(composite, 2048);
            this.chromatogramReportFolderOrFileTextBox.setLayoutData((Object)new GridData(768));
            this.buttonSelectFileOrFolder = new Button(composite, 0);
            this.buttonSelectFileOrFolder.setText(this.appendReports ? "Select report file" : "Select report folder");
            this.buttonSelectFileOrFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String reportFolderOrFile;
                    Shell shell = Display.getCurrent().getActiveShell();
                    if (ChromatogramReportEntriesWizardPage.this.appendReports) {
                        String fileName = "ChromatogramReport";
                        String[] filterExtensions = new String[]{"*.*"};
                        String[] filterNames = new String[]{"Chromatogram Report File (*.*)"};
                        try {
                            IChromatogramReportSupplier reportSupplier = ChromatogramReportEntriesWizardPage.this.getReportSupplier();
                            fileName = reportSupplier.getFileName();
                            filterExtensions = new String[]{"*" + reportSupplier.getFileExtension()};
                            filterNames = new String[]{reportSupplier.getReportName()};
                        }
                        catch (NoReportSupplierAvailableException e1) {
                            logger.warn((Object)e1);
                        }
                        FileDialog fileDialog = new FileDialog(shell, 8192);
                        fileDialog.setText("Select a chromatogram report file:");
                        fileDialog.setFileName(fileName);
                        fileDialog.setFilterExtensions(filterExtensions);
                        fileDialog.setOverwrite(true);
                        fileDialog.setFilterNames(filterNames);
                        reportFolderOrFile = fileDialog.open();
                    } else {
                        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
                        directoryDialog.setText("Select a chromatogram report folder:");
                        reportFolderOrFile = directoryDialog.open();
                    }
                    if (reportFolderOrFile != null) {
                        ChromatogramReportEntriesWizardPage.this.chromatogramReportFolderOrFileTextBox.setText(reportFolderOrFile);
                    }
                }
            });
        }
        catch (NoReportSupplierAvailableException noReportSupplierAvailableException) {
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.heightHint = 30;
            this.label = new Label(composite, 0);
            this.label.setText("Sorry, there are no report supplier available.");
            this.label.setLayoutData((Object)gridData);
        }
        this.setControl((Control)composite);
    }
}

