/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.chromatogram;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramConverterSupport;
import org.eclipse.chemclipse.converter.chromatogram.ChromatogramSupplier;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramExportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.IChromatogramMSDExportConverter;
import org.eclipse.chemclipse.msd.converter.chromatogram.IChromatogramMSDImportConverter;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.ChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.IChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public final class ChromatogramConverterMSD {
    private static final Logger logger = Logger.getLogger(ChromatogramConverterMSD.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.msd.converter.chromatogramSupplier";

    private ChromatogramConverterMSD() {
    }

    public static IChromatogramMSDImportConverterProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        IChromatogramMSDImportConverter importConverter = ChromatogramConverterMSD.getChromatogramImportConverter(converterId);
        IChromatogramMSDImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : ChromatogramConverterMSD.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramMSDImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getChromatogram(file, false, monitor);
        ChromatogramMSDImportConverterProcessingInfo processingInfoImport = new ChromatogramMSDImportConverterProcessingInfo();
        processingInfoImport.addMessages(processingInfo);
        processingInfoImport.setProcessingResult(processingInfo.getProcessingResult());
        return processingInfoImport;
    }

    private static IProcessingInfo getChromatogram(File file, boolean overview, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ArrayList processingMessagesError = new ArrayList();
        ChromatogramConverterSupport converterSupport = ChromatogramConverterMSD.getChromatogramConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                Object object;
                Object processingInfox;
                IChromatogramMSDImportConverter importConverter = ChromatogramConverterMSD.getChromatogramImportConverter(converterId);
                if (importConverter == null) continue;
                if (overview) {
                    processingInfox = importConverter.convertOverview(file, monitor);
                    if (!processingInfox.hasErrorMessages()) {
                        object = processingInfox.getProcessingResult();
                        if (!(object instanceof IChromatogramOverview)) continue;
                        processingInfo.addMessages((IProcessingInfo)processingInfox);
                        processingInfo.setProcessingResult(object);
                        break;
                    }
                    processingMessagesError.addAll(processingInfox.getMessages());
                    continue;
                }
                processingInfox = importConverter.convert(file, monitor);
                if (!processingInfox.hasErrorMessages()) {
                    object = processingInfox.getProcessingResult();
                    if (!(object instanceof IChromatogramMSD)) continue;
                    processingInfo.addMessages((IProcessingInfo)processingInfox);
                    processingInfo.setProcessingResult(object);
                    break;
                }
                processingMessagesError.addAll(processingInfox.getMessages());
            }
        }
        catch (NoConverterAvailableException noConverterAvailableException) {
            processingInfo.addErrorMessage("Chromatogram Export Converter", "There is no suitable converter available to save the chromatogram to the file: " + file.getAbsolutePath());
        }
        if (processingInfo.getProcessingResult() == null) {
            for (IProcessingMessage processingMessage : processingMessagesError) {
                processingInfo.addMessage(processingMessage);
            }
        }
        return processingInfo;
    }

    public static IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, String converterId, IProgressMonitor monitor) {
        IChromatogramMSDImportConverter importConverter = ChromatogramConverterMSD.getChromatogramImportConverter(converterId);
        IChromatogramOverviewImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convertOverview(file, monitor) : ChromatogramConverterMSD.getNoOverviewImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getChromatogram(file, true, monitor);
        ChromatogramOverviewImportConverterProcessingInfo processingInfoImport = new ChromatogramOverviewImportConverterProcessingInfo();
        processingInfoImport.addMessages(processingInfo);
        processingInfoImport.setProcessingResult(processingInfo.getProcessingResult());
        return processingInfoImport;
    }

    public static IChromatogramExportConverterProcessingInfo convert(File file, IChromatogramMSD chromatogram, String converterId, IProgressMonitor monitor) {
        IChromatogramMSDExportConverter exportConverter = ChromatogramConverterMSD.getChromatogramExportConverter(converterId);
        IChromatogramExportConverterProcessingInfo processingInfo = exportConverter != null ? exportConverter.convert(file, chromatogram, monitor) : ChromatogramConverterMSD.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IChromatogramMSDImportConverter getChromatogramImportConverter(String converterId) {
        IConfigurationElement element = ChromatogramConverterMSD.getConfigurationElement(converterId);
        IChromatogramMSDImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramMSDImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IChromatogramMSDExportConverter getChromatogramExportConverter(String converterId) {
        IConfigurationElement element = ChromatogramConverterMSD.getConfigurationElement(converterId);
        IChromatogramMSDExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramMSDExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static ChromatogramConverterSupport getChromatogramConverterSupport() {
        IConfigurationElement[] extensions;
        ChromatogramConverterSupport chromatogramConverterSupport = new ChromatogramConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramSupplier supplier = new ChromatogramSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")).booleanValue());
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")).booleanValue());
                supplier.setMagicNumberMatcher(ChromatogramConverterMSD.getMagicNumberMatcher(element));
                chromatogramConverterSupport.add((ISupplier)supplier);
            }
            ++n2;
        }
        return chromatogramConverterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception exception) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static IChromatogramExportConverterProcessingInfo getNoExportConverterAvailableProcessingInfo(File file) {
        ChromatogramExportConverterProcessingInfo processingInfo = new ChromatogramExportConverterProcessingInfo();
        processingInfo.addErrorMessage("Chromatogram Export Converter", "There is no suitable converter available to save the chromatogram to the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IChromatogramMSDImportConverterProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        ChromatogramMSDImportConverterProcessingInfo processingInfo = new ChromatogramMSDImportConverterProcessingInfo();
        processingInfo.addErrorMessage("Chromatogram Import Converter", "There is no suitable converter available to load the chromatogram from the file: " + file.getAbsolutePath());
        return processingInfo;
    }

    private static IChromatogramOverviewImportConverterProcessingInfo getNoOverviewImportConverterAvailableProcessingInfo(File file) {
        ChromatogramOverviewImportConverterProcessingInfo processingInfo = new ChromatogramOverviewImportConverterProcessingInfo();
        processingInfo.addErrorMessage("ChromatogramOverview Import Converter", "There is no suitable converter available to load the chromatogram overview from the file: " + file.getAbsolutePath());
        return processingInfo;
    }
}

