/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.massspectrum;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.massspectrum.IMassSpectrumExportConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.IMassSpectrumImportConverter;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverterSupport;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumSupplier;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.MassSpectrumExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.MassSpectrumImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class MassSpectrumConverter {
    private static final Logger logger = Logger.getLogger(MassSpectrumConverter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.msd.converter.massSpectrumSupplier";

    private MassSpectrumConverter() {
    }

    public static IMassSpectrumImportConverterProcessingInfo convert(File file, String converterId, IProgressMonitor monitor) {
        IMassSpectrumImportConverter importConverter = MassSpectrumConverter.getMassSpectrumImportConverter(converterId);
        IMassSpectrumImportConverterProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : MassSpectrumConverter.getNoImportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IMassSpectrumImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        IMassSpectrumImportConverterProcessingInfo processingInfo = MassSpectrumConverter.getMassSpectra(file, monitor);
        return processingInfo;
    }

    private static IMassSpectrumImportConverterProcessingInfo getMassSpectra(File file, IProgressMonitor monitor) {
        IMassSpectrumImportConverterProcessingInfo processingInfo = new MassSpectrumImportConverterProcessingInfo();
        MassSpectrumConverterSupport converterSupport = MassSpectrumConverter.getMassSpectrumConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            for (String converterId : availableConverterIds) {
                IMassSpectrumImportConverter importConverter = MassSpectrumConverter.getMassSpectrumImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, monitor)).hasErrorMessages()) continue;
                return processingInfo;
            }
        }
        catch (NoConverterAvailableException e) {
            logger.info((Object)e);
            processingInfo = MassSpectrumConverter.getNoImportConverterAvailableProcessingInfo(file);
        }
        return processingInfo;
    }

    public static IMassSpectrumExportConverterProcessingInfo convert(File file, IScanMSD massSpectrum, boolean append, String converterId, IProgressMonitor monitor) {
        IMassSpectrumExportConverter exportConverter = MassSpectrumConverter.getMassSpectrumExportConverter(converterId);
        IMassSpectrumExportConverterProcessingInfo processingInfo = exportConverter != null ? exportConverter.convert(file, massSpectrum, append, monitor) : MassSpectrumConverter.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    public static IMassSpectrumExportConverterProcessingInfo convert(File file, IMassSpectra massSpectra, boolean append, String converterId, IProgressMonitor monitor) {
        IMassSpectrumExportConverter exportConverter = MassSpectrumConverter.getMassSpectrumExportConverter(converterId);
        IMassSpectrumExportConverterProcessingInfo processingInfo = exportConverter != null ? exportConverter.convert(file, massSpectra, append, monitor) : MassSpectrumConverter.getNoExportConverterAvailableProcessingInfo(file);
        return processingInfo;
    }

    private static IMassSpectrumImportConverter getMassSpectrumImportConverter(String converterId) {
        IConfigurationElement element = MassSpectrumConverter.getConfigurationElement(converterId);
        IMassSpectrumImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IMassSpectrumExportConverter getMassSpectrumExportConverter(String converterId) {
        IConfigurationElement element = MassSpectrumConverter.getConfigurationElement(converterId);
        IMassSpectrumExportConverter instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumExportConverter)element.createExecutableExtension("exportConverter");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static MassSpectrumConverterSupport getMassSpectrumConverterSupport() {
        IConfigurationElement[] extensions;
        MassSpectrumConverterSupport massSpectrumConverterSupport = new MassSpectrumConverterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MassSpectrumSupplier supplier = new MassSpectrumSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")));
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")));
                massSpectrumConverterSupport.add(supplier);
            }
            ++n2;
        }
        return massSpectrumConverterSupport;
    }

    private static IMassSpectrumExportConverterProcessingInfo getNoExportConverterAvailableProcessingInfo(File file) {
        MassSpectrumExportConverterProcessingInfo processingInfo = new MassSpectrumExportConverterProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "MassSpectrum Export Converter", "There is no suitable converter available to export the mass spectra to the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }

    private static IMassSpectrumImportConverterProcessingInfo getNoImportConverterAvailableProcessingInfo(File file) {
        MassSpectrumImportConverterProcessingInfo processingInfo = new MassSpectrumImportConverterProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.WARN, "MassSpectrum Import Converter", "There is no suitable converter available to load the mass spectra from the file: " + file.getAbsolutePath());
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

