/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.IMassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.processing.MassSpectrumFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.internal.calculator.SubtractCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISubtractFilterSettingsMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "Subtract Filter Mass Spectrum";

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        MassSpectrumFilterProcessingInfo processingInfo = new MassSpectrumFilterProcessingInfo();
        processingInfo.addMessages(this.validate(massSpectra, massSpectrumFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (massSpectrumFilterSettings instanceof ISubtractFilterSettingsMassSpectrum) {
            ISubtractFilterSettingsMassSpectrum subtractFilterSettings = (ISubtractFilterSettingsMassSpectrum)massSpectrumFilterSettings;
            SubtractCalculator subtractCalculator = new SubtractCalculator();
            subtractCalculator.subtractMassSpectra(massSpectra, subtractFilterSettings);
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been subtracted successfully."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + ISubtractFilterSettingsMassSpectrum.class);
        }
        MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The subtract filter has been applied successfully.");
        processingInfo.setMassSpectrumFilterResult((IMassSpectrumFilterResult)massSpectrumFilterResult);
        return processingInfo;
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        return this.applyFilter(massSpectra, massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(IScanMSD massSpectrum, IProgressMonitor monitor) {
        ISubtractFilterSettingsMassSpectrum massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectrum, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }

    public IMassSpectrumFilterProcessingInfo applyFilter(List<IScanMSD> massSpectra, IProgressMonitor monitor) {
        ISubtractFilterSettingsMassSpectrum massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        return this.applyFilter(massSpectra, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, monitor);
    }
}

