/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.ext.internal.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.swtchart.IBarSeries;
import org.swtchart.IDisposeListener;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.ext.InteractiveChart;
import org.swtchart.ext.internal.properties.AbstractSelectorPage;
import org.swtchart.ext.internal.properties.PropertiesResources;

public class SeriesPage
extends AbstractSelectorPage {
    private static final String SERIES_LINE_COLOR = "org.swtchart.series.line.color";
    private static final String SERIES_SYMBOL_COLOR = "org.swtchart.series.symbol.color";
    private static final String SERIES_BAR_COLOR = "org.swtchart.series.bar.color";
    protected Button visibleButton;
    protected Button stackedButton;
    protected Combo xAxisIdCombo;
    protected Combo yAxisIdCombo;
    protected ColorSelector lineColorButton;
    protected Combo lineStyleCombo;
    protected ColorSelector symbolColorButton;
    protected Combo symbolTypeCombo;
    protected Spinner symbolSizeSpinner;
    protected ColorSelector barColorButton;
    protected Spinner paddingSizeSpinner;
    private ISeries[] series;
    private int[] xAxisIdItems;
    private int[] yAxisIdItems;
    protected boolean[] visibleStates;
    protected boolean[] stackedStates;
    protected int[] xAxisIds;
    protected int[] yAxisIds;
    protected RGB[] lineColors;
    protected LineStyle[] lineStyles;
    protected RGB[] symbolColors;
    protected ILineSeries.PlotSymbolType[] symbolTypes;
    protected int[] symbolSizes;
    protected RGB[] barColors;
    protected int[] paddings;
    private Composite stackPanel;
    private StackLayout stackLayout;
    private Composite lineSeriesGroup;
    private Composite barSeriesGroup;

    public SeriesPage(InteractiveChart chart, PropertiesResources resources, String title) {
        super(chart, resources, title, "Series:");
        this.series = chart.getSeriesSet().getSeries();
        this.xAxisIdItems = chart.getAxisSet().getXAxisIds();
        this.yAxisIdItems = chart.getAxisSet().getYAxisIds();
        this.visibleStates = new boolean[this.series.length];
        this.stackedStates = new boolean[this.series.length];
        this.xAxisIds = new int[this.series.length];
        this.yAxisIds = new int[this.series.length];
        this.lineColors = new RGB[this.series.length];
        this.lineStyles = new LineStyle[this.series.length];
        this.symbolColors = new RGB[this.series.length];
        this.symbolTypes = new ILineSeries.PlotSymbolType[this.series.length];
        this.symbolSizes = new int[this.series.length];
        this.barColors = new RGB[this.series.length];
        this.paddings = new int[this.series.length];
    }

    @Override
    protected String[] getListItems() {
        String[] items = new String[this.series.length];
        int i = 0;
        while (i < items.length) {
            items[i] = String.valueOf(this.series[i].getId());
            ++i;
        }
        return items;
    }

    @Override
    protected void selectInitialValues() {
        int i = 0;
        while (i < this.series.length) {
            this.visibleStates[i] = this.series[i].isVisible();
            this.stackedStates[i] = this.series[i].isStackEnabled();
            if (this.series[i] instanceof ILineSeries) {
                this.lineColors[i] = ((ILineSeries)this.series[i]).getLineColor().getRGB();
                this.lineStyles[i] = ((ILineSeries)this.series[i]).getLineStyle();
                this.symbolColors[i] = ((ILineSeries)this.series[i]).getSymbolColor().getRGB();
                this.symbolTypes[i] = ((ILineSeries)this.series[i]).getSymbolType();
                this.symbolSizes[i] = ((ILineSeries)this.series[i]).getSymbolSize();
            } else if (this.series[i] instanceof IBarSeries) {
                this.barColors[i] = ((IBarSeries)this.series[i]).getBarColor().getRGB();
                this.paddings[i] = ((IBarSeries)this.series[i]).getBarPadding();
            }
            this.xAxisIds[i] = this.series[i].getXAxisId();
            this.yAxisIds[i] = this.series[i].getYAxisId();
            ++i;
        }
        this.updateStackPanel();
    }

    @Override
    protected void updateControlSelections() {
        this.visibleButton.setSelection(this.visibleStates[this.selectedIndex]);
        this.stackedButton.setSelection(this.stackedStates[this.selectedIndex]);
        if (this.xAxisIdCombo != null) {
            this.xAxisIdCombo.setText("" + this.xAxisIds[this.selectedIndex]);
        }
        if (this.yAxisIdCombo != null) {
            this.yAxisIdCombo.setText("" + this.yAxisIds[this.selectedIndex]);
        }
        if (this.series[this.selectedIndex] instanceof ILineSeries) {
            this.lineStyleCombo.setText(this.lineStyles[this.selectedIndex].label);
            this.lineStyleCombo.setEnabled(true);
            this.lineColorButton.setColorValue(this.lineColors[this.selectedIndex]);
            this.symbolColorButton.setColorValue(this.symbolColors[this.selectedIndex]);
            this.symbolTypeCombo.setText(this.symbolTypes[this.selectedIndex].label);
            this.symbolSizeSpinner.setSelection(this.symbolSizes[this.selectedIndex]);
        } else if (this.series[this.selectedIndex] instanceof IBarSeries) {
            this.barColorButton.setColorValue(this.barColors[this.selectedIndex]);
            this.paddingSizeSpinner.setSelection(this.paddings[this.selectedIndex]);
        }
        this.setControlsEnable(this.series[this.selectedIndex].isVisible());
        this.updateStackPanel();
    }

    private void updateStackPanel() {
        if (this.series[this.selectedIndex] instanceof ILineSeries) {
            this.stackLayout.topControl = this.lineSeriesGroup;
        } else if (this.series[this.selectedIndex] instanceof IBarSeries) {
            this.stackLayout.topControl = this.barSeriesGroup;
        }
        this.stackPanel.layout();
    }

    @Override
    protected void addRightPanelContents(Composite parent) {
        this.addSeriesGroup(parent);
        this.stackPanel = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackPanel.setLayout((Layout)this.stackLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.stackPanel.setLayoutData((Object)gridData);
        this.addLineSeriesGroup(this.stackPanel);
        this.addBarSeriesGroup(this.stackPanel);
    }

    private void addSeriesGroup(Composite parent) {
        int i;
        String[] items;
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, true));
        this.visibleButton = this.createCheckBoxControl(group, "Show plot");
        this.visibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible;
                SeriesPage.this.visibleStates[SeriesPage.this.selectedIndex] = visible = SeriesPage.this.visibleButton.getSelection();
                SeriesPage.this.setControlsEnable(visible);
            }
        });
        this.stackedButton = this.createCheckBoxControl(group, "Stacked series");
        this.stackedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesPage.this.stackedStates[SeriesPage.this.selectedIndex] = SeriesPage.this.stackedButton.getSelection();
            }
        });
        if (this.xAxisIdItems.length > 1) {
            this.createLabelControl(group, "X Axis:");
            items = new String[this.xAxisIdItems.length];
            i = 0;
            while (i < items.length) {
                items[i] = "" + this.xAxisIdItems[i];
                ++i;
            }
            this.xAxisIdCombo = this.createComboControl(group, items);
            this.xAxisIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SeriesPage.this.xAxisIds[SeriesPage.this.selectedIndex] = Integer.parseInt(SeriesPage.this.xAxisIdCombo.getText());
                }
            });
        }
        if (this.yAxisIdItems.length > 1) {
            this.createLabelControl(group, "Y Axis:");
            items = new String[this.yAxisIdItems.length];
            i = 0;
            while (i < items.length) {
                items[i] = "" + this.yAxisIdItems[i];
                ++i;
            }
            this.yAxisIdCombo = this.createComboControl(group, items);
            this.yAxisIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SeriesPage.this.yAxisIds[SeriesPage.this.selectedIndex] = Integer.parseInt(SeriesPage.this.yAxisIdCombo.getText());
                }
            });
        }
    }

    private void addLineSeriesGroup(Composite parent) {
        this.lineSeriesGroup = this.createGroupControl(parent, "Line series:", true);
        this.stackLayout.topControl = this.lineSeriesGroup;
        this.createLabelControl(this.lineSeriesGroup, "Line color:");
        this.lineColorButton = this.createColorButtonControl(this.lineSeriesGroup);
        this.lineColorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SeriesPage.this.lineColors[SeriesPage.this.selectedIndex] = SeriesPage.this.lineColorButton.getColorValue();
            }
        });
        this.createLabelControl(this.lineSeriesGroup, "Line style:");
        LineStyle[] styles = LineStyle.values();
        String[] labels = new String[styles.length];
        int i = 0;
        while (i < styles.length) {
            labels[i] = styles[i].label;
            ++i;
        }
        this.lineStyleCombo = this.createComboControl(this.lineSeriesGroup, labels);
        this.lineStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = SeriesPage.this.lineStyleCombo.getText();
                LineStyle selectedStyle = LineStyle.NONE;
                LineStyle[] lineStyleArray = LineStyle.values();
                int n = lineStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LineStyle style = lineStyleArray[n2];
                    if (style.label.equals(value)) {
                        selectedStyle = style;
                    }
                    ++n2;
                }
                SeriesPage.this.lineStyles[SeriesPage.this.selectedIndex] = selectedStyle;
            }
        });
        this.createLabelControl(this.lineSeriesGroup, "Symbol color:");
        this.symbolColorButton = this.createColorButtonControl(this.lineSeriesGroup);
        this.symbolColorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SeriesPage.this.symbolColors[SeriesPage.this.selectedIndex] = SeriesPage.this.symbolColorButton.getColorValue();
            }
        });
        this.createLabelControl(this.lineSeriesGroup, "Symbol type:");
        ILineSeries.PlotSymbolType[] types = ILineSeries.PlotSymbolType.values();
        labels = new String[types.length];
        int i2 = 0;
        while (i2 < types.length) {
            labels[i2] = types[i2].label;
            ++i2;
        }
        this.symbolTypeCombo = this.createComboControl(this.lineSeriesGroup, labels);
        this.symbolTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = SeriesPage.this.symbolTypeCombo.getText();
                ILineSeries.PlotSymbolType selectedType = ILineSeries.PlotSymbolType.CIRCLE;
                ILineSeries.PlotSymbolType[] plotSymbolTypeArray = ILineSeries.PlotSymbolType.values();
                int n = plotSymbolTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILineSeries.PlotSymbolType type = plotSymbolTypeArray[n2];
                    if (type.label.equals(value)) {
                        selectedType = type;
                    }
                    ++n2;
                }
                SeriesPage.this.symbolTypes[SeriesPage.this.selectedIndex] = selectedType;
            }
        });
        this.createLabelControl(this.lineSeriesGroup, "Symbol size:");
        this.symbolSizeSpinner = this.createSpinnerControl(this.lineSeriesGroup, 1, 10);
        this.symbolSizeSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SeriesPage.this.symbolSizes[SeriesPage.this.selectedIndex] = SeriesPage.this.symbolSizeSpinner.getSelection();
            }
        });
    }

    private void addBarSeriesGroup(Composite parent) {
        this.barSeriesGroup = new Composite(parent, 0);
        this.barSeriesGroup.setLayout((Layout)new GridLayout(1, true));
        this.barSeriesGroup.setLayoutData((Object)new GridData(768));
        Group group = this.createGroupControl(this.barSeriesGroup, "Bar series:", true);
        this.createLabelControl((Composite)group, "Color:");
        this.barColorButton = this.createColorButtonControl((Composite)group);
        this.barColorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SeriesPage.this.barColors[SeriesPage.this.selectedIndex] = SeriesPage.this.barColorButton.getColorValue();
            }
        });
        this.createLabelControl((Composite)group, "Padding size:");
        this.paddingSizeSpinner = this.createSpinnerControl((Composite)group, 0, 100);
        this.paddingSizeSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SeriesPage.this.paddings[SeriesPage.this.selectedIndex] = SeriesPage.this.paddingSizeSpinner.getSelection();
            }
        });
    }

    protected void setControlsEnable(boolean enabled) {
        this.lineColorButton.setEnabled(enabled);
        this.lineStyleCombo.setEnabled(enabled);
        this.stackedButton.setEnabled(enabled);
        if (this.xAxisIdCombo != null) {
            this.xAxisIdCombo.setEnabled(enabled);
        }
        if (this.yAxisIdCombo != null) {
            this.yAxisIdCombo.setEnabled(enabled);
        }
        this.barColorButton.setEnabled(enabled);
        this.paddingSizeSpinner.setEnabled(enabled);
    }

    @Override
    public void apply() {
        int i = 0;
        while (i < this.series.length) {
            this.series[i].setVisible(this.visibleStates[i]);
            if (this.series[i] instanceof ILineSeries) {
                Color lineColor = new Color((Device)Display.getDefault(), this.lineColors[i]);
                ((ILineSeries)this.series[i]).setLineColor(lineColor);
                final String lineColorKey = SERIES_LINE_COLOR + this.series[i].getId();
                if (this.resources.getColor(lineColorKey) == null) {
                    this.series[i].addDisposeListener(new IDisposeListener(){

                        @Override
                        public void disposed(Event e) {
                            SeriesPage.this.resources.removeColor(lineColorKey);
                        }
                    });
                }
                this.resources.put(lineColorKey, lineColor);
                Color symbolColor = new Color((Device)Display.getDefault(), this.symbolColors[i]);
                ((ILineSeries)this.series[i]).setSymbolColor(symbolColor);
                final String symbolColorKey = SERIES_SYMBOL_COLOR + this.series[i].getId();
                if (this.resources.getColor(symbolColorKey) == null) {
                    this.series[i].addDisposeListener(new IDisposeListener(){

                        @Override
                        public void disposed(Event e) {
                            SeriesPage.this.resources.removeColor(symbolColorKey);
                        }
                    });
                }
                this.resources.put(symbolColorKey, symbolColor);
                ((ILineSeries)this.series[i]).setLineStyle(this.lineStyles[i]);
                ((ILineSeries)this.series[i]).setSymbolType(this.symbolTypes[i]);
                ((ILineSeries)this.series[i]).setSymbolSize(this.symbolSizes[i]);
            } else if (this.series[i] instanceof IBarSeries) {
                Color barColor = new Color((Device)Display.getDefault(), this.barColors[i]);
                ((IBarSeries)this.series[i]).setBarColor(barColor);
                final String barColorKey = SERIES_BAR_COLOR + this.series[i].getId();
                if (this.resources.getColor(barColorKey) == null) {
                    this.series[i].addDisposeListener(new IDisposeListener(){

                        @Override
                        public void disposed(Event e) {
                            SeriesPage.this.resources.removeColor(barColorKey);
                        }
                    });
                }
                this.resources.put(barColorKey, barColor);
                ((IBarSeries)this.series[i]).setBarPadding(this.paddings[i]);
            }
            try {
                this.series[i].enableStack(this.stackedStates[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.stackedStates[i] = false;
                this.stackedButton.setSelection(false);
            }
            this.series[i].setXAxisId(this.xAxisIds[i]);
            this.series[i].setYAxisId(this.yAxisIds[i]);
            ++i;
        }
    }

    protected void performDefaults() {
        this.visibleStates[this.selectedIndex] = true;
        this.stackedStates[this.selectedIndex] = false;
        if (this.xAxisIdCombo != null) {
            this.xAxisIds[this.selectedIndex] = 0;
        }
        if (this.yAxisIdCombo != null) {
            this.yAxisIds[this.selectedIndex] = 0;
        }
        if (this.series[this.selectedIndex] instanceof ILineSeries) {
            this.lineStyles[this.selectedIndex] = LineStyle.SOLID;
            this.lineColors[this.selectedIndex] = Display.getDefault().getSystemColor(9).getRGB();
            this.symbolColors[this.selectedIndex] = Display.getDefault().getSystemColor(16).getRGB();
            this.symbolTypes[this.selectedIndex] = ILineSeries.PlotSymbolType.CIRCLE;
            this.symbolSizes[this.selectedIndex] = 4;
        } else if (this.series[this.selectedIndex] instanceof IBarSeries) {
            this.barColors[this.selectedIndex] = Display.getDefault().getSystemColor(9).getRGB();
            this.paddings[this.selectedIndex] = 20;
        }
        this.updateControlSelections();
        super.performDefaults();
    }
}

