/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.IPeakIdentificationBatchJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakInputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakOutputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakProcessEntry;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentificationBatchJobWriter
implements IPeakIdentificationBatchJobWriter {
    @Override
    public void writeBatchProcessJob(File file, IPeakIdentificationBatchJob peakIdentificationBatchJob, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException, XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(bufferedOutputStream, "UTF-8");
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        eventWriter.add(eventFactory.createStartDocument());
        StartElement chromatogramStart = eventFactory.createStartElement("", "", "PeakIdentificationBatchJob");
        eventWriter.add(chromatogramStart);
        this.writeBatchProcessJobHeader(eventWriter, eventFactory, peakIdentificationBatchJob);
        this.writeComment(eventWriter, eventFactory, "Load the following peaks.");
        this.writePeakInputEntries(eventWriter, eventFactory, peakIdentificationBatchJob.getPeakInputEntries());
        this.writeComment(eventWriter, eventFactory, "Use the following peak integrator.");
        this.writePeakIntegratorEntry(eventWriter, eventFactory, peakIdentificationBatchJob.getPeakIntegrationEntry());
        this.writeComment(eventWriter, eventFactory, "Use the following peak identifier.");
        this.writePeakIdentificationEntry(eventWriter, eventFactory, peakIdentificationBatchJob.getPeakIdentificationEntry());
        this.writeComment(eventWriter, eventFactory, "Export the peaks to the following formats.");
        this.writePeakOutputEntries(eventWriter, eventFactory, peakIdentificationBatchJob.getPeakOutputEntries());
        EndElement chromatogramEnd = eventFactory.createEndElement("", "", "PeakIdentificationBatchJob");
        eventWriter.add(chromatogramEnd);
        eventWriter.add(eventFactory.createEndDocument());
        bufferedOutputStream.flush();
        eventWriter.flush();
        bufferedOutputStream.close();
        eventWriter.close();
    }

    private void writeComment(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String comment) throws XMLStreamException {
        Comment batchJobInfo = eventFactory.createComment(comment);
        eventWriter.add(batchJobInfo);
    }

    private void writeBatchProcessJobHeader(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IPeakIdentificationBatchJob peakIdentificationBatchJob) throws XMLStreamException {
        StartElement headerStart = eventFactory.createStartElement("", "", "Header");
        EndElement headerEnd = eventFactory.createEndElement("", "", "Header");
        eventWriter.add(headerStart);
        this.writeReportFolder(eventWriter, eventFactory, peakIdentificationBatchJob.getReportFolder());
        this.writeOverrideReport(eventWriter, eventFactory, peakIdentificationBatchJob.isOverrideReport());
        eventWriter.add(headerEnd);
    }

    private void writeReportFolder(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String reportFolder) throws XMLStreamException {
        StartElement operatorStart = eventFactory.createStartElement("", "", "ReportFolder");
        EndElement operatorEnd = eventFactory.createEndElement("", "", "ReportFolder");
        if (reportFolder == null || reportFolder.equals("")) {
            reportFolder = "";
        }
        Characters operator = eventFactory.createCData(reportFolder);
        eventWriter.add(operatorStart);
        eventWriter.add(operator);
        eventWriter.add(operatorEnd);
    }

    private void writeOverrideReport(XMLEventWriter eventWriter, XMLEventFactory eventFactory, boolean overrideReports) throws XMLStreamException {
        StartElement operatorStart = eventFactory.createStartElement("", "", "OverrideReport");
        EndElement operatorEnd = eventFactory.createEndElement("", "", "OverrideReport");
        Characters operator = eventFactory.createCData(Boolean.toString(overrideReports));
        eventWriter.add(operatorStart);
        eventWriter.add(operator);
        eventWriter.add(operatorEnd);
    }

    private void writePeakInputEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IPeakInputEntry> inputEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "InputEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "InputEntries");
        eventWriter.add(entriesStart);
        for (IPeakInputEntry inputEntry : inputEntries) {
            this.writePeakInputEntry(eventWriter, eventFactory, inputEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writePeakInputEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IPeakInputEntry inputEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "InputEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "InputEntry");
        Characters inputFile = eventFactory.createCData(inputEntry.getInputFile());
        eventWriter.add(entryStart);
        eventWriter.add(inputFile);
        eventWriter.add(entryEnd);
    }

    private void writePeakOutputEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IPeakOutputEntry> outputEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "OutputEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "OutputEntries");
        eventWriter.add(entriesStart);
        for (IPeakOutputEntry inputEntry : outputEntries) {
            this.writePeakOutputEntry(eventWriter, eventFactory, inputEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writePeakOutputEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IPeakOutputEntry outputEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "OutputEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "OutputEntry");
        Attribute converterId = eventFactory.createAttribute("converterId", outputEntry.getConverterId());
        Characters outputFolder = eventFactory.createCData(outputEntry.getOutputFolder());
        eventWriter.add(entryStart);
        eventWriter.add(converterId);
        eventWriter.add(outputFolder);
        eventWriter.add(entryEnd);
    }

    private void writePeakIntegratorEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IPeakProcessEntry peakProcessEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "IntegrationEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "IntegrationEntry");
        eventWriter.add(entryStart);
        if (peakProcessEntry != null) {
            Attribute processorType = eventFactory.createAttribute("INTEGRATOR", "integrator");
            Attribute report = eventFactory.createAttribute("processReport", Boolean.toString(peakProcessEntry.isReport()));
            Attribute processorId = eventFactory.createAttribute("processorId", peakProcessEntry.getProcessorId());
            eventWriter.add(processorType);
            eventWriter.add(report);
            eventWriter.add(processorId);
        }
        eventWriter.add(entryEnd);
    }

    private void writePeakIdentificationEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IPeakProcessEntry peakProcessEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "IdentificationEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "IdentificationEntry");
        eventWriter.add(entryStart);
        if (peakProcessEntry != null) {
            Attribute processorType = eventFactory.createAttribute("IDENTIFIER", "identifier");
            Attribute report = eventFactory.createAttribute("processReport", Boolean.toString(peakProcessEntry.isReport()));
            Attribute processorId = eventFactory.createAttribute("processorId", peakProcessEntry.getProcessorId());
            eventWriter.add(processorType);
            eventWriter.add(report);
            eventWriter.add(processorId);
        }
        eventWriter.add(entryEnd);
    }
}

