/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.series;

import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.swt.ui.series.ISeries;

public class Series
implements ISeries {
    private double[] xSeries;
    private double[] ySeries;
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double yMin = 0.0;
    private double yMax = 0.0;
    String id = "";

    public Series(double[] xSeries, double[] ySeries, String id) {
        if (xSeries != null) {
            this.xSeries = xSeries;
        } else {
            xSeries = new double[]{0.0};
        }
        if (ySeries != null) {
            this.ySeries = ySeries;
        } else {
            ySeries = new double[]{0.0};
        }
        if (id != null) {
            this.id = id;
        }
        this.xMin = Calculations.getMin((double[])xSeries);
        this.yMin = Calculations.getMin((double[])ySeries);
        this.xMax = Calculations.getMax((double[])xSeries);
        this.yMax = Calculations.getMax((double[])ySeries);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double[] getXSeries() {
        return this.xSeries;
    }

    @Override
    public double[] getYSeries() {
        return this.ySeries;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Series otherSeries = (Series)other;
        return this.id.equals(otherSeries.getId()) && this.xSeries.length == otherSeries.getXSeries().length && this.getXMin() == otherSeries.getXMin() && this.getXMax() == otherSeries.getXMax() && this.ySeries.length == otherSeries.getYSeries().length && this.getYMin() == otherSeries.getYMin() && this.getYMax() == otherSeries.getYMax();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("id=" + this.id);
        builder.append(",");
        builder.append("xMin=" + this.getXMin());
        builder.append(",");
        builder.append("xMax=" + this.getXMax());
        builder.append(",");
        builder.append("xSeries.length=" + this.xSeries.length);
        builder.append(",");
        builder.append("yMin=" + this.getYMin());
        builder.append(",");
        builder.append("yMax=" + this.getYMax());
        builder.append(",");
        builder.append("ySeries.length=" + this.ySeries.length);
        builder.append("]");
        return builder.toString();
    }
}

