/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support.Calculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support.INoiseSegment;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support.IonNoise;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.internal.core.support.IonNoiseAbundanceComparator;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.AnalysisSupportException;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.ICombinedMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalsModifier;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.core.runtime.IProgressMonitor;

public class Denoising {
    private static final Logger logger = Logger.getLogger(Denoising.class);
    private static IonNoiseAbundanceComparator ionNoiseAbundanceComparator = new IonNoiseAbundanceComparator(SortOrder.DESC);

    private Denoising() {
    }

    public static List<ICombinedMassSpectrum> applyDenoisingFilter(IChromatogramSelectionMSD chromatogramSelection, IMarkedIons ionsToRemove, IMarkedIons ionsToPreserve, boolean adjustThresholdTransitions, int numberOfUsedIonsForCoefficient, SegmentWidth segmentWidth, IProgressMonitor monitor) throws FilterException {
        ExtractedIonSignalExtractor extractedIonSignalExtractor;
        if (ionsToRemove == null) {
            throw new FilterException("The ions to remove instance was null.");
        }
        if (ionsToPreserve == null) {
            throw new FilterException("The ions to preserve instance was null.");
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
        }
        catch (ChromatogramIsNullException chromatogramIsNullException) {
            throw new FilterException("The chromatogram must be not null.");
        }
        IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals(chromatogramSelection);
        Calculator calculator = new Calculator();
        monitor.subTask("Remove selected ions.");
        extractedIonSignals = Denoising.removeIonsInScanRange(extractedIonSignals, ionsToRemove, monitor);
        if (adjustThresholdTransitions) {
            try {
                monitor.subTask("Adjust threshold transitions.");
                ExtractedIonSignalsModifier.adjustThresholdTransitions((IExtractedIonSignals)extractedIonSignals);
            }
            catch (AnalysisSupportException e) {
                logger.warn((Object)e);
            }
        }
        List<INoiseSegment> noiseSegments = calculator.getNoiseSegments(extractedIonSignals, ionsToPreserve, segmentWidth, monitor);
        List<ICombinedMassSpectrum> noiseMassSpectra = Denoising.subtractNoiseMassSpectraFromSegments(extractedIonSignals, noiseSegments, ionsToPreserve, numberOfUsedIonsForCoefficient, monitor);
        monitor.subTask("Write the results.");
        Denoising.writeExtractedIonSignalsBackToChromatogram(chromatogram, extractedIonSignals, monitor);
        return noiseMassSpectra;
    }

    private static IExtractedIonSignals removeIonsInScanRange(IExtractedIonSignals extractedIonSignals, IMarkedIons ionsToRemove, IProgressMonitor monitor) {
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            monitor.subTask("Remove calculated noise from scan: " + scan);
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                Denoising.removeIons(extractedIonSignal, ionsToRemove);
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
        return extractedIonSignals;
    }

    private static void removeIons(IExtractedIonSignal extractedIonSignal, IMarkedIons selectedIons) {
        Iterator iterator = selectedIons.getIonsNominal().iterator();
        while (iterator.hasNext()) {
            int ion = (Integer)iterator.next();
            extractedIonSignal.setAbundance(ion, 0.0f, true);
        }
    }

    private static void subtractNoiseMassSpectrumFromScanRange(IExtractedIonSignals extractedIonSignals, ICombinedMassSpectrum noiseMassSpectrum, int startScan, int stopScan, int numberOfUsedIonsForCoefficient, IProgressMonitor monitor) {
        int scan = startScan;
        while (scan <= stopScan) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                Denoising.subtractNoiseMassSpectrumFromScan(extractedIonSignal, noiseMassSpectrum, numberOfUsedIonsForCoefficient, monitor);
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
    }

    private static void subtractNoiseMassSpectrumFromScan(IExtractedIonSignal extractedIonSignal, ICombinedMassSpectrum noiseMassSpectrum, int numberOfUsedIonsForCoefficient, IProgressMonitor monitor) {
        IExtractedIonSignal noiseSignal = noiseMassSpectrum.getExtractedIonSignal();
        float correlationFactor = Denoising.calculateCoefficient(extractedIonSignal, noiseSignal, numberOfUsedIonsForCoefficient);
        if (correlationFactor <= 0.0f) {
            return;
        }
        int startIon = noiseSignal.getStartIon();
        int stopIon = noiseSignal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                float subtractAbundance = correlationFactor * noiseSignal.getAbundance(ion);
                float newAbundance = abundance - subtractAbundance;
                if (newAbundance <= 0.0f) {
                    extractedIonSignal.setAbundance(ion, 0.0f, true);
                } else {
                    extractedIonSignal.setAbundance(ion, newAbundance, true);
                }
            }
            ++ion;
        }
    }

    private static float calculateCoefficient(IExtractedIonSignal extractedIonSignal, IExtractedIonSignal noiseSignal, int numberOfUsedIonsForCoefficient) {
        int startIon = noiseSignal.getStartIon();
        int stopIon = noiseSignal.getStopIon();
        float coefficient = 0.0f;
        ArrayList<IonNoise> entries = new ArrayList<IonNoise>();
        int ion = startIon;
        while (ion <= stopIon) {
            entries.add(new IonNoise(ion, noiseSignal.getAbundance(ion)));
            ++ion;
        }
        Collections.sort(entries, ionNoiseAbundanceComparator);
        ArrayList<Float> coefficients = new ArrayList<Float>();
        int counter = 0;
        for (IonNoise entry : entries) {
            float abundanceScan;
            float abundanceNoise = noiseSignal.getAbundance(entry.getIon());
            if (!(abundanceNoise > 0.0f) || !((abundanceScan = extractedIonSignal.getAbundance(entry.getIon())) > 0.0f)) continue;
            coefficient = abundanceScan / abundanceNoise;
            coefficients.add(Float.valueOf(coefficient));
            if (++counter > numberOfUsedIonsForCoefficient) break;
        }
        int size = coefficients.size();
        float[] values = new float[size];
        int i = 0;
        while (i < size) {
            values[i] = ((Float)coefficients.get(i)).floatValue();
            ++i;
        }
        return Calculations.getMean((float[])values);
    }

    private static void writeExtractedIonSignalsBackToChromatogram(IChromatogramMSD chromatogram, IExtractedIonSignals extractedIonSignals, IProgressMonitor monitor) {
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        int scan = startScan;
        while (scan <= stopScan) {
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
                Denoising.replaceIons(extractedIonSignal, supplierMassSpectrum);
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
    }

    private static void replaceIons(IExtractedIonSignal extractedIonSignal, IVendorMassSpectrum supplierMassSpectrum) {
        int startIon = extractedIonSignal.getStartIon();
        int stopIon = extractedIonSignal.getStopIon();
        supplierMassSpectrum.removeAllIons();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                try {
                    Ion defaultIon = new Ion((double)ion, abundance);
                    supplierMassSpectrum.addIon((IIon)defaultIon);
                }
                catch (AbundanceLimitExceededException e) {
                    logger.warn((Object)e);
                }
                catch (IonLimitExceededException e) {
                    logger.warn((Object)e);
                }
            }
            ++ion;
        }
    }

    private static List<ICombinedMassSpectrum> subtractNoiseMassSpectraFromSegments(IExtractedIonSignals extractedIonSignals, List<INoiseSegment> noiseSegments, IMarkedIons ionsToPreserve, int numberOfUsedIonsForCoefficient, IProgressMonitor monitor) {
        ArrayList<ICombinedMassSpectrum> noiseMassSpectra = new ArrayList<ICombinedMassSpectrum>();
        Calculator calculator = new Calculator();
        int segments = noiseSegments.size();
        boolean firstRun = true;
        int segment = 0;
        while (segment < segments) {
            int stopScan;
            int startScan;
            System.out.println(segment);
            ArrayList<ICombinedMassSpectrum> segmentNoiseMassSpectra = new ArrayList<ICombinedMassSpectrum>();
            INoiseSegment currentNoiseSegment = noiseSegments.get(segment);
            segmentNoiseMassSpectra.add(currentNoiseSegment.getNoiseMassSpectrum());
            if (segment == 0 && firstRun) {
                startScan = extractedIonSignals.getStartScan();
                stopScan = currentNoiseSegment.getAnalysisSegment().getStopScan() - Denoising.calculateTailingScans(currentNoiseSegment);
                firstRun = false;
                --segment;
            } else if (segment == segments - 1) {
                startScan = currentNoiseSegment.getAnalysisSegment().getStartScan() + Denoising.calculateLeadingScans(currentNoiseSegment);
                stopScan = extractedIonSignals.getStopScan();
            } else {
                INoiseSegment followingNoiseSegment = noiseSegments.get(segment + 1);
                startScan = currentNoiseSegment.getAnalysisSegment().getStartScan() + Denoising.calculateLeadingScans(currentNoiseSegment);
                stopScan = followingNoiseSegment.getAnalysisSegment().getStopScan() - Denoising.calculateTailingScans(followingNoiseSegment);
                segmentNoiseMassSpectra.add(followingNoiseSegment.getNoiseMassSpectrum());
            }
            ICombinedMassSpectrum noiseMassSpectrum = calculator.getNoiseMassSpectrum(segmentNoiseMassSpectra, ionsToPreserve, monitor);
            noiseMassSpectrum.setStartScan(startScan);
            noiseMassSpectrum.setStopScan(stopScan);
            noiseMassSpectrum.setStartRetentionTime(extractedIonSignals.getChromatogram().getScan(startScan).getRetentionTime());
            noiseMassSpectrum.setStopRetentionTime(extractedIonSignals.getChromatogram().getScan(stopScan).getRetentionTime());
            noiseMassSpectra.add(noiseMassSpectrum);
            monitor.subTask("Substract the noise mass spectrum from the scans: " + startScan + " - " + stopScan);
            Denoising.subtractNoiseMassSpectrumFromScanRange(extractedIonSignals, noiseMassSpectrum, startScan, stopScan, numberOfUsedIonsForCoefficient, monitor);
            ++segment;
        }
        return noiseMassSpectra;
    }

    private static int calculateLeadingScans(INoiseSegment noiseSegment) {
        int width = noiseSegment.getAnalysisSegment().getSegmentWidth();
        int result = 0;
        if (width > 0) {
            result = width / 2;
        }
        return result;
    }

    private static int calculateTailingScans(INoiseSegment noiseSegment) {
        int width = noiseSegment.getAnalysisSegment().getSegmentWidth();
        int result = 0;
        if (width > 0) {
            result = width % 2 == 0 ? width / 2 : width / 2 + 1;
        }
        return result;
    }
}

