/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.Activator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.settings.SupplierFilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.support.SegmentWidth;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_IONS_TO_REMOVE = "ionsToRemove";
    public static final String P_IONS_TO_PRESERVE = "ionsToPreserve";
    public static final String P_SEGMENT_WIDTH = "segmentWidth";
    public static final String P_USE_CHROMATOGRAM_SPECIFIC_IONS = "useChromatogramSpecificIons";
    public static final String P_ADJUST_THRESHOLD_TRANSITIONS = "adjustThresholdTransitions";
    public static final String DEF_IONS_TO_REMOVE = "18;28;84;207";
    public static final String DEF_IONS_TO_PRESERVE = "103;104";
    public static final String DEF_SEGMENT_WIDTH = SegmentWidth.WIDTH_13.toString();
    public static final boolean DEF_USE_CHROMATOGRAM_SPECIFIC_IONS = false;
    public static final boolean DEF_ADJUST_THRESHOLD_TRANSITIONS = true;
    private static final Logger logger = Logger.getLogger(PreferenceSupplier.class);
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
        defaultValues.put(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE);
        defaultValues.put(P_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH);
        defaultValues.put(P_USE_CHROMATOGRAM_SPECIFIC_IONS, Boolean.toString(false));
        defaultValues.put(P_ADJUST_THRESHOLD_TRANSITIONS, Boolean.toString(true));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static IChromatogramFilterSettings getChromatogramFilterSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        SupplierFilterSettings chromatogramFilterSettings = new SupplierFilterSettings();
        chromatogramFilterSettings.setAdjustThresholdTransitions(preferences.getBoolean(P_ADJUST_THRESHOLD_TRANSITIONS, true));
        chromatogramFilterSettings.setNumberOfUsedIonsForCoefficient(1);
        IMarkedIons ionsToRemove = chromatogramFilterSettings.getIonsToRemove();
        PreferenceSupplier.setMarkedIons(ionsToRemove, PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE));
        IMarkedIons ionsToPreserve = chromatogramFilterSettings.getIonsToPreserve();
        PreferenceSupplier.setMarkedIons(ionsToPreserve, PreferenceSupplier.getIons(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE));
        SegmentWidth segmentWidth = SegmentWidth.valueOf((String)preferences.get(P_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH));
        chromatogramFilterSettings.setSegmentWidth(segmentWidth);
        return chromatogramFilterSettings;
    }

    public static void setMarkedIons(IMarkedIons markedIons, Set<Integer> ions) {
        for (int ion : ions) {
            markedIons.add((Object)new MarkedIon((double)ion));
        }
    }

    public static Set<Integer> getIons(String preference, String def) {
        String[] items;
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        HashSet<Integer> ions = new HashSet<Integer>();
        String preferenceEntry = preferences.get(preference, def);
        if (preferenceEntry != "" && (items = PreferenceSupplier.parseString(preferenceEntry)).length > 0) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    Integer ion = Integer.parseInt(item);
                    ions.add(ion);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
                ++n2;
            }
        }
        return ions;
    }

    public static String[] parseString(String stringList) {
        String[] decodedArray;
        if (stringList.contains(";")) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringList, ";");
            int arraySize = stringTokenizer.countTokens();
            decodedArray = new String[arraySize];
            int i = 0;
            while (i < arraySize) {
                decodedArray[i] = stringTokenizer.nextToken(";");
                ++i;
            }
        } else {
            decodedArray = new String[]{stringList};
        }
        return decodedArray;
    }

    public static String createList(String[] items) {
        String ions = "";
        if (items != null) {
            int size = items.length;
            int i = 0;
            while (i < size) {
                ions = ions.concat(String.valueOf(items[i]) + ";");
                ++i;
            }
        }
        return ions;
    }

    public static boolean adjustThresholdTransitions() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_ADJUST_THRESHOLD_TRANSITIONS, true);
    }

    public static boolean useChromatogramSpecificIons() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_USE_CHROMATOGRAM_SPECIFIC_IONS, false);
    }

    public static Set<Integer> getIonsToRemove() {
        return PreferenceSupplier.getIons(P_IONS_TO_REMOVE, DEF_IONS_TO_REMOVE);
    }

    public static Set<Integer> getIonsToPreserve() {
        return PreferenceSupplier.getIons(P_IONS_TO_PRESERVE, DEF_IONS_TO_PRESERVE);
    }

    public static SegmentWidth getSegmentWidth() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return SegmentWidth.valueOf((String)preferences.get(P_SEGMENT_WIDTH, DEF_SEGMENT_WIDTH));
    }
}

