/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.massspectrum.MassSpectrumConverter;
import org.eclipse.chemclipse.msd.converter.processing.massspectrum.IMassSpectrumImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DatabasesCache {
    private static final Logger logger = Logger.getLogger(DatabasesCache.class);
    private static Map<String, Long> fileSizes;
    private static Map<String, Long> fileModifications;
    private static Set<String> fileNames;
    private static Map<String, IMassSpectra> massSpectraDatabases;
    private static Map<String, Map<String, IScanMSD>> allDatabaseNames;
    private static Map<String, Map<String, IScanMSD>> allDatabaseCasNumbers;
    private IonAbundanceComparator ionAbundanceComparator = new IonAbundanceComparator(SortOrder.DESC);
    private List<String> massSpectraFiles;

    static {
        allDatabaseNames = null;
        allDatabaseCasNumbers = null;
    }

    public DatabasesCache(List<String> massSpectraFiles) {
        this.massSpectraFiles = massSpectraFiles;
        DatabasesCache.initializeDatabaseMaps();
    }

    public static void resetCache() {
        DatabasesCache.initializeDatabaseMaps();
    }

    public IonAbundanceComparator getIonAbundanceComparator() {
        return this.ionAbundanceComparator;
    }

    public Map<String, IMassSpectra> getDatabases(List<String> databaseList, IProgressMonitor monitor) throws FileNotFoundException {
        ArrayList<String> databaseNames = new ArrayList<String>();
        for (String database : databaseList) {
            try {
                File file = new File(database);
                String databaseName = file.getName();
                databaseNames.add(databaseName);
                if (!file.exists()) continue;
                if (massSpectraDatabases.get(databaseName) == null) {
                    this.loadMassSpectraFromFile(file, monitor);
                    continue;
                }
                if (file.length() == fileSizes.get(databaseName).longValue() && file.lastModified() == fileModifications.get(databaseName).longValue() && fileNames.contains(databaseName)) continue;
                this.loadMassSpectraFromFile(file, monitor);
            }
            catch (TypeCastException e) {
                logger.warn((Object)e);
            }
        }
        Set<String> databaseKeys = massSpectraDatabases.keySet();
        for (String databaseKey : databaseKeys) {
            if (databaseNames.contains(databaseKey)) continue;
            massSpectraDatabases.remove(databaseKey);
            allDatabaseNames.remove(databaseKey);
            allDatabaseCasNumbers.remove(databaseKey);
        }
        if (massSpectraDatabases.size() == 0) {
            throw new FileNotFoundException();
        }
        return massSpectraDatabases;
    }

    public List<IScanMSD> getDatabaseMassSpectra(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        if (identificationTarget != null) {
            try {
                String casNumber;
                String name;
                ILibraryInformation libraryInformation = identificationTarget.getLibraryInformation();
                String databaseName = libraryInformation.getDatabase();
                Map<String, Map<String, IScanMSD>> allDatabaseNames = this.getDatabaseNamesMap(monitor);
                Map<String, Map<String, IScanMSD>> allDatabaseCasNumbers = this.getDatabaseCasNamesMap(monitor);
                Map<String, IScanMSD> databaseNames = allDatabaseNames.get(databaseName);
                Map<String, IScanMSD> databaseCasNumbers = allDatabaseCasNumbers.get(databaseName);
                IScanMSD reference = null;
                if (databaseNames != null && (reference = databaseNames.get(name = libraryInformation.getName())) != null) {
                    massSpectra.add(reference);
                }
                if (reference == null && databaseCasNumbers != null && (reference = databaseCasNumbers.get(casNumber = libraryInformation.getCasNumber())) != null) {
                    massSpectra.add(reference);
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectra;
    }

    private Map<String, Map<String, IScanMSD>> getDatabaseNamesMap(IProgressMonitor monitor) throws FileNotFoundException {
        this.getDatabases(this.massSpectraFiles, monitor);
        return allDatabaseNames;
    }

    private Map<String, Map<String, IScanMSD>> getDatabaseCasNamesMap(IProgressMonitor monitor) throws FileNotFoundException {
        this.getDatabases(this.massSpectraFiles, monitor);
        return allDatabaseCasNumbers;
    }

    private void loadMassSpectraFromFile(File file, IProgressMonitor monitor) throws TypeCastException {
        Map<String, IScanMSD> databaseCasNumbers;
        IMassSpectrumImportConverterProcessingInfo infoConvert = MassSpectrumConverter.convert((File)file, (IProgressMonitor)monitor);
        IMassSpectra massSpectraDatabase = infoConvert.getMassSpectra();
        String databaseName = file.getName();
        massSpectraDatabases.put(databaseName, massSpectraDatabase);
        fileNames.add(databaseName);
        fileSizes.put(databaseName, file.length());
        fileModifications.put(databaseName, file.lastModified());
        Map<String, IScanMSD> databaseNames = allDatabaseNames.get(databaseName);
        if (databaseNames == null) {
            databaseNames = new HashMap<String, IScanMSD>();
            allDatabaseNames.put(databaseName, databaseNames);
        }
        if ((databaseCasNumbers = allDatabaseCasNumbers.get(databaseName)) == null) {
            databaseCasNumbers = new HashMap<String, IScanMSD>();
            allDatabaseCasNumbers.put(databaseName, databaseCasNumbers);
        }
        for (IScanMSD reference : massSpectraDatabase.getList()) {
            if (!(reference instanceof IRegularLibraryMassSpectrum)) continue;
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)reference;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            databaseNames.put(libraryInformation.getName(), reference);
            databaseCasNumbers.put(libraryInformation.getCasNumber(), reference);
        }
    }

    private static void initializeDatabaseMaps() {
        if (fileSizes == null) {
            fileSizes = new HashMap<String, Long>();
        }
        if (fileModifications == null) {
            fileModifications = new HashMap<String, Long>();
        }
        if (fileNames == null) {
            fileNames = new HashSet<String>();
        }
        if (massSpectraDatabases == null) {
            massSpectraDatabases = new HashMap<String, IMassSpectra>();
        }
        if (allDatabaseNames == null) {
            allDatabaseNames = new HashMap<String, Map<String, IScanMSD>>();
        }
        if (allDatabaseCasNumbers == null) {
            allDatabaseCasNumbers = new HashMap<String, Map<String, IScanMSD>>();
        }
    }
}

