/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzxml.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.IChromatogramImportConverter;
import org.eclipse.chemclipse.converter.processing.chromatogram.ChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.converter.processing.chromatogram.IChromatogramOverviewImportConverterProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.AbstractChromatogramMSDImportConverter;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.ChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.chromatogram.IChromatogramMSDImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.internal.io.SpecificationValidator;
import org.eclipse.chemclipse.msd.converter.supplier.mzxml.io.ChromatogramReader;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramMSDImportConverter
implements IChromatogramImportConverter {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);
    private static final String DESCRIPTION = "mzXML Import Converter";

    public IChromatogramMSDImportConverterProcessingInfo convert(File file, IProgressMonitor monitor) {
        ChromatogramMSDImportConverterProcessingInfo processingInfo = new ChromatogramMSDImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import mzXML Chromatogram");
            try {
                IChromatogramMSD chromatogram = reader.read(file, monitor);
                processingInfo.setChromatogram(chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IChromatogramOverviewImportConverterProcessingInfo convertOverview(File file, IProgressMonitor monitor) {
        ChromatogramOverviewImportConverterProcessingInfo processingInfo = new ChromatogramOverviewImportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = super.validate(file);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import mzXML Chromatogram Overview");
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setChromatogramOverview(chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

