/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.internal.swt.ProcessingInfoUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ProcessingInfoPart
implements EventHandler {
    public static String ID = "org.eclipse.chemclipse.processing.ui.parts.ProcessingInfoPart";
    private static final String POPUP_MENU_ID = "#PopUpMenu";
    private static final String POPUP_MENU_POSTFIX = "PopUpMenu";
    @Inject
    private Composite parent;
    @Inject
    private EPartService partService;
    @Inject
    private MPart part;
    private static IProcessingInfo processingInfo;
    private ProcessingInfoUI processingInfoUI;

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.processingInfoUI = new ProcessingInfoUI(this.parent, 0);
        TableViewer tableViewer = this.processingInfoUI.getTableViewer();
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    ProcessingInfoPart.this.processingInfoUI.copyToClipboard();
                }
            }
        });
        this.initContextMenu();
    }

    @PreDestroy
    private void preDestroy() {
    }

    @Focus
    public void setFocus() {
        this.update(this.getProcessingInfo());
    }

    public void update(IProcessingInfo processingInfo) {
        if (this.doUpdate(processingInfo)) {
            this.processingInfoUI.update(processingInfo);
            this.processingInfoUI.setFocus();
        }
    }

    public IProcessingInfo getProcessingInfo() {
        return processingInfo;
    }

    public void setProcessingInfo(IProcessingInfo processingInfoNew) {
        processingInfo = processingInfoNew;
    }

    public boolean doUpdate(IProcessingInfo processingInfo) {
        return this.isPartVisible() && processingInfo != null;
    }

    public boolean isPartVisible() {
        return this.partService != null && this.partService.isPartVisible(this.part);
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager(POPUP_MENU_ID, String.valueOf(this.getClass().getName()) + POPUP_MENU_POSTFIX);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        ProcessingInfoPart.this.processingInfoUI.copyToClipboard();
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        TableViewer tableViewer = this.processingInfoUI.getTableViewer();
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    public void handleEvent(Event event) {
        Object object = event.getProperty("org.eclipse.e4.data");
        if (object instanceof IProcessingInfo) {
            processingInfo = (IProcessingInfo)object;
            this.update(processingInfo);
        }
    }
}

