/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IPeak) {
            IPeak peak = (IPeak)element;
            IPeakModel peakModel = peak.getPeakModel();
            IScan peakMaximum = peakModel.getPeakMaximum();
            switch (columnIndex) {
                case 0: {
                    text = this.decimalFormat.format((double)peakMaximum.getRetentionTime() / 60000.0);
                    break;
                }
                case 1: {
                    if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                        text = Integer.toString((int)peakMaximum.getRetentionIndex());
                        break;
                    }
                    text = this.decimalFormat.format(peakMaximum.getRetentionIndex());
                    break;
                }
                case 2: {
                    if (peak instanceof IChromatogramPeakMSD) {
                        text = this.decimalFormat.format(((IChromatogramPeakMSD)peak).getSignalToNoiseRatio());
                        break;
                    }
                    if (!(peak instanceof IChromatogramPeakCSD)) break;
                    text = this.decimalFormat.format(((IChromatogramPeakCSD)peak).getSignalToNoiseRatio());
                    break;
                }
                case 3: {
                    text = this.decimalFormat.format(peak.getIntegratedArea());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("peak.gif", "16x16");
        return image;
    }
}

