/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PeakQuantitationEntriesLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationEntryMSD) {
            IQuantitationEntryMSD quantitationEntryMSD = (IQuantitationEntryMSD)element;
            switch (columnIndex) {
                case 0: {
                    text = quantitationEntryMSD.getName();
                    break;
                }
                case 1: {
                    text = quantitationEntryMSD.getChemicalClass();
                    break;
                }
                case 2: {
                    text = decimalFormat.format(quantitationEntryMSD.getConcentration());
                    break;
                }
                case 3: {
                    text = quantitationEntryMSD.getConcentrationUnit();
                    break;
                }
                case 4: {
                    text = decimalFormat.format(quantitationEntryMSD.getArea());
                    break;
                }
                case 5: {
                    double ion = quantitationEntryMSD.getIon();
                    if (ion == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = decimalFormat.format(ion);
                    break;
                }
                case 6: {
                    text = quantitationEntryMSD.getCalibrationMethod();
                    break;
                }
                case 7: {
                    text = Boolean.toString(quantitationEntryMSD.getUsedCrossZero());
                    break;
                }
                case 8: {
                    text = quantitationEntryMSD.getDescription();
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("integrationResults.gif", "16x16");
    }
}

