/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.report.core.IChromatogramReportSupportSetter;
import org.eclipse.chemclipse.chromatogram.xxd.report.exceptions.NoReportSupplierAvailableException;

public abstract class AbstractChromatogramReportSupport
implements IChromatogramReportSupportSetter {
    private List<IChromatogramReportSupplier> suppliers = new ArrayList<IChromatogramReportSupplier>();

    @Override
    public void add(IChromatogramReportSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String[] getReportExtensions() throws NoReportSupplierAvailableException {
        this.areReportSuppliersStored();
        ArrayList<String> extensions = new ArrayList<String>();
        for (IChromatogramReportSupplier supplier : this.suppliers) {
            String extension = supplier.getFileExtension();
            extensions.add(extension);
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Override
    public String[] getFilterNames() throws NoReportSupplierAvailableException {
        this.areReportSuppliersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (IChromatogramReportSupplier supplier : this.suppliers) {
            filterNames.add(supplier.getReportName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public String getReportSupplierId(int index) throws NoReportSupplierAvailableException {
        this.areReportSuppliersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoReportSupplierAvailableException("The index is out of range.");
        }
        IChromatogramReportSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String getReportSupplierId(String name) throws NoReportSupplierAvailableException {
        this.areReportSuppliersStored();
        String id = "";
        for (IChromatogramReportSupplier supplier : this.suppliers) {
            if (!supplier.getReportName().equals(name)) continue;
            id = supplier.getId();
            break;
        }
        if (id.equals("")) {
            throw new NoReportSupplierAvailableException("There is no chromatogram report generator available.");
        }
        return id;
    }

    @Override
    public List<IChromatogramReportSupplier> getReportSupplier() {
        return this.suppliers;
    }

    @Override
    public IChromatogramReportSupplier getReportSupplier(String id) throws NoReportSupplierAvailableException {
        IChromatogramReportSupplier instance = null;
        for (IChromatogramReportSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(id)) continue;
            instance = supplier;
            break;
        }
        if (instance == null) {
            throw new NoReportSupplierAvailableException("There is no chromatogram report generator available with the given id: " + id + ".");
        }
        return instance;
    }

    private void areReportSuppliersStored() throws NoReportSupplierAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoReportSupplierAvailableException();
        }
    }
}

