/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.ui.swt;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.FilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassValueDisplayPrecision;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.SimpleMassSpectrumUI;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CombinedMassSpectrumUI
extends Composite {
    private DecimalFormat decimalFormat;
    private Label label;
    private SimpleMassSpectrumUI simpleMassSpectrumUI;

    public CombinedMassSpectrumUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0##");
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite labelbar = new Composite(composite, 4);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        labelbar.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        labelbar.setLayoutData((Object)gridData);
        this.label = new Label(labelbar, 0);
        this.label.setText("");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gridData);
        this.simpleMassSpectrumUI = new SimpleMassSpectrumUI(composite, 0, MassValueDisplayPrecision.NOMINAL);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.simpleMassSpectrumUI.setLayoutData(gridData);
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (chromatogramSelection != null) {
            boolean useNormalize = PreferenceSupplier.isUseNormalize();
            IScanMSD massSpectrum = FilterSupport.getCombinedMassSpectrum((IChromatogramSelectionMSD)chromatogramSelection, null, (boolean)useNormalize);
            this.setMassSpectrumLabel(chromatogramSelection);
            this.simpleMassSpectrumUI.update(massSpectrum, forceReload);
        }
    }

    private void setMassSpectrumLabel(IChromatogramSelectionMSD chromatogramSelection) {
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        StringBuilder builder = new StringBuilder();
        builder.append("Scan range: ");
        builder.append(chromatogramSelection.getChromatogram().getScanNumber(startRetentionTime));
        builder.append("\u2013");
        builder.append(chromatogramSelection.getChromatogram().getScanNumber(stopRetentionTime));
        builder.append(" | RT range: ");
        builder.append(this.decimalFormat.format((double)startRetentionTime / 60000.0));
        builder.append("\u2013");
        builder.append(this.decimalFormat.format((double)stopRetentionTime / 60000.0));
        this.label.setText(builder.toString());
    }
}

