/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.runnables;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.LibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.ILibraryServiceProcessingInfo;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractMassSpectrumLibraryView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class LibraryServiceRunnable
implements IRunnableWithProgress {
    private AbstractMassSpectrumLibraryView massSpectrumLibraryView;
    private IScanMSD unknownMassSpectrum;
    private IIdentificationTarget identificationTarget;

    public LibraryServiceRunnable(AbstractMassSpectrumLibraryView massSpectrumLibraryView, IScanMSD unknownMassSpectrum, IIdentificationTarget identificationTarget) {
        this.massSpectrumLibraryView = massSpectrumLibraryView;
        this.unknownMassSpectrum = unknownMassSpectrum;
        this.identificationTarget = identificationTarget;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Library Service", -1);
            try {
                ILibraryServiceProcessingInfo processingInfo = LibraryService.identify((IIdentificationTarget)this.identificationTarget, (IProgressMonitor)monitor);
                IMassSpectra massSpectra = processingInfo.getMassSpectra();
                if (massSpectra.size() > 0) {
                    IScanMSD libraryMassSpectrum = massSpectra.getMassSpectrum(1);
                    this.updateSelection(this.unknownMassSpectrum, libraryMassSpectrum, true);
                }
            }
            catch (Exception exception) {
                this.updateSelection(this.unknownMassSpectrum, null, true);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection(final IScanMSD unknownMassSpectrum, final IScanMSD libraryMassSpectrum, final boolean forceReload) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LibraryServiceRunnable.this.massSpectrumLibraryView.update(unknownMassSpectrum, libraryMassSpectrum, forceReload);
            }
        });
    }
}

