/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.wizards;

import org.eclipse.chemclipse.support.ui.wizards.IChromatogramWizardElements;
import org.eclipse.chemclipse.support.ui.wizards.TreeViewerFilesystemSupport;
import org.eclipse.chemclipse.ux.extension.msd.ui.support.ChromatogramSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.ChromatogramFileExplorerContentProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.ChromatogramFileExplorerLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChromatogramInputEntriesWizardPage
extends WizardPage {
    private TreeViewer chromatogramViewer;
    private IChromatogramWizardElements chromatogramWizardElements;

    public ChromatogramInputEntriesWizardPage(IChromatogramWizardElements chromatogramWizardElements) {
        super(ChromatogramInputEntriesWizardPage.class.getName());
        this.setTitle("Open Chromatogram (MSD) File(s)");
        this.setDescription("Select a chromatogram/chromatograms file to open.");
        this.chromatogramWizardElements = chromatogramWizardElements;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.chromatogramViewer = new TreeViewer(composite, 2);
        this.chromatogramViewer.setLabelProvider((IBaseLabelProvider)new ChromatogramFileExplorerLabelProvider(ChromatogramSupport.getInstanceIdentifier()));
        this.chromatogramViewer.setContentProvider((IContentProvider)new ChromatogramFileExplorerContentProvider(ChromatogramSupport.getInstanceIdentifier()));
        this.chromatogramViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChromatogramInputEntriesWizardPage.this.chromatogramWizardElements.clearSelectedChromatograms();
                ISelection selection = ChromatogramInputEntriesWizardPage.this.chromatogramViewer.getSelection();
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object element : structuredSelection.toList()) {
                    ChromatogramInputEntriesWizardPage.this.chromatogramWizardElements.addSelectedChromatogram(element.toString());
                }
            }
        });
        TreeViewerFilesystemSupport.retrieveAndSetLocalFileSystem((TreeViewer)this.chromatogramViewer);
        this.setControl((Control)composite);
    }
}

