/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class QuantitationCompoundLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IQuantitationCompoundMSD) {
            IQuantitationCompoundMSD compound = (IQuantitationCompoundMSD)element;
            IRetentionTimeWindow retentionTimeWindow = compound.getRetentionTimeWindow();
            IRetentionIndexWindow retentionIndexWindow = compound.getRetentionIndexWindow();
            switch (columnIndex) {
                case 0: {
                    text = compound.getName();
                    break;
                }
                case 1: {
                    text = compound.getChemicalClass();
                    break;
                }
                case 2: {
                    text = compound.getConcentrationUnit();
                    break;
                }
                case 3: {
                    text = compound.getCalibrationMethod().toString();
                    break;
                }
                case 4: {
                    text = Boolean.toString(compound.isCrossZero());
                    break;
                }
                case 5: {
                    text = Boolean.toString(compound.isUseTIC());
                    break;
                }
                case 6: {
                    text = decimalFormat.format((double)retentionTimeWindow.getRetentionTime() / 60000.0);
                    break;
                }
                case 7: {
                    text = decimalFormat.format((double)retentionTimeWindow.getAllowedNegativeDeviation() / 60000.0);
                    break;
                }
                case 8: {
                    text = decimalFormat.format((double)retentionTimeWindow.getAllowedPositiveDeviation() / 60000.0);
                    break;
                }
                case 9: {
                    text = decimalFormat.format(retentionIndexWindow.getRetentionIndex());
                    break;
                }
                case 10: {
                    text = decimalFormat.format(retentionIndexWindow.getAllowedNegativeDeviation());
                    break;
                }
                case 11: {
                    text = decimalFormat.format(retentionIndexWindow.getAllowedPositiveDeviation());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("quantifySelectedPeak.gif", "16x16");
    }
}

