/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddAllPeakPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(AddAllPeakPage.class);
    private Text textConcentration;
    private Text textConcentrationUnit;
    private Text textChemicalClass;
    private double concentration;
    private String concentrationUnit;
    private String chemicalClass;
    private DecimalFormat decimalFormat;

    public AddAllPeakPage(String pageName) {
        super(pageName);
        this.setTitle("Peaks to Quantitation Table");
        this.setDescription("Set the concentration details.");
        this.concentration = 0.0;
        this.concentrationUnit = "";
        this.chemicalClass = "";
        this.setErrorMessage("Please add a concentration.");
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    protected double getConcentration() {
        return this.concentration;
    }

    protected String getConcentrationUnit() {
        return this.concentrationUnit;
    }

    protected String getChemicalClass() {
        return this.chemicalClass;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        Label label = new Label(composite, 0);
        label.setText("Concentration*:");
        this.textConcentration = new Text(composite, 2048);
        this.textConcentration.setLayoutData((Object)gridData);
        this.textConcentration.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = AddAllPeakPage.this.textConcentration.getText();
                if (value == null || value.equals("")) {
                    AddAllPeakPage.this.setErrorMessage("Please set a concentration.");
                } else {
                    try {
                        AddAllPeakPage.this.concentration = AddAllPeakPage.this.decimalFormat.parse(value).doubleValue();
                        AddAllPeakPage.this.setErrorMessage(null);
                    }
                    catch (ParseException e1) {
                        logger.warn((Object)e1);
                        AddAllPeakPage.this.setErrorMessage("Please type in a valid concentration.");
                    }
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Concentration Unit*:");
        this.textConcentrationUnit = new Text(composite, 2048);
        this.textConcentrationUnit.setLayoutData((Object)gridData);
        this.textConcentrationUnit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = AddAllPeakPage.this.textConcentrationUnit.getText();
                if (value == null || value.equals("")) {
                    AddAllPeakPage.this.setErrorMessage("Please set a concentration unit.");
                } else {
                    AddAllPeakPage.this.concentrationUnit = value;
                    AddAllPeakPage.this.setErrorMessage(null);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Chemical Class:");
        this.textChemicalClass = new Text(composite, 2048);
        this.textChemicalClass.setLayoutData((Object)gridData);
        this.textChemicalClass.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String value = AddAllPeakPage.this.textChemicalClass.getText();
                if (value != null && !value.equals("")) {
                    AddAllPeakPage.this.chemicalClass = value;
                }
            }
        });
        this.setControl((Control)composite);
    }
}

