/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CellSelectionDragMode
implements IDragMode {
    private Point lastDragInCellPosition = null;

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.lastDragInCellPosition = new Point(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        Rectangle clientArea = natTable.getClientAreaProvider().getClientArea();
        int x = event.x;
        int y = event.y;
        SelectionLayer.MoveDirectionEnum horizontal = SelectionLayer.MoveDirectionEnum.NONE;
        if (event.x < 0) {
            horizontal = SelectionLayer.MoveDirectionEnum.LEFT;
            x = 0;
        } else if (event.x > clientArea.width) {
            horizontal = SelectionLayer.MoveDirectionEnum.RIGHT;
            x = clientArea.width;
        }
        SelectionLayer.MoveDirectionEnum vertical = SelectionLayer.MoveDirectionEnum.NONE;
        if (event.y < 0) {
            vertical = SelectionLayer.MoveDirectionEnum.UP;
            y = 0;
        } else if (event.y > clientArea.height) {
            vertical = SelectionLayer.MoveDirectionEnum.DOWN;
            y = clientArea.height;
        }
        if (!SelectionLayer.MoveDirectionEnum.NONE.equals((Object)horizontal) || !SelectionLayer.MoveDirectionEnum.NONE.equals((Object)vertical)) {
            this.lastDragInCellPosition = null;
        }
        if (natTable.doCommand(new ViewportDragCommand(horizontal, vertical))) {
            int selectedColumnPosition = natTable.getColumnPositionByX(x);
            int selectedRowPosition = natTable.getRowPositionByY(y);
            if (selectedColumnPosition > -1 && selectedRowPosition > -1) {
                Point dragInCellPosition = new Point(selectedColumnPosition, selectedRowPosition);
                if (this.lastDragInCellPosition == null || !dragInCellPosition.equals((Object)this.lastDragInCellPosition)) {
                    this.lastDragInCellPosition = dragInCellPosition;
                    this.fireSelectionCommand(natTable, selectedColumnPosition, selectedRowPosition, true, false);
                }
            }
        }
    }

    public void fireSelectionCommand(NatTable natTable, int columnPosition, int rowPosition, boolean shiftMask, boolean controlMask) {
        natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition, shiftMask, controlMask));
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        this.lastDragInCellPosition = null;
    }
}

