/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.mode.IModeEventHandler;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;

public class ModeSupport
implements KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
FocusListener {
    private Map<String, IModeEventHandler> modeEventHandlerMap = new HashMap<String, IModeEventHandler>();
    private IModeEventHandler currentModeEventHandler;

    public ModeSupport(NatTable natTable) {
        natTable.addKeyListener(this);
        natTable.addMouseListener(this);
        natTable.addMouseMoveListener(this);
        natTable.addMouseTrackListener(this);
        natTable.addFocusListener(this);
    }

    public void registerModeEventHandler(String mode, IModeEventHandler modeEventHandler) {
        this.modeEventHandlerMap.put(mode, modeEventHandler);
    }

    public void switchMode(String mode) {
        if (this.currentModeEventHandler != null) {
            this.currentModeEventHandler.cleanup();
        }
        this.currentModeEventHandler = this.modeEventHandlerMap.get(mode);
    }

    public void switchMode(IModeEventHandler modeEventHandler) {
        if (this.currentModeEventHandler != null) {
            this.currentModeEventHandler.cleanup();
        }
        this.currentModeEventHandler = modeEventHandler;
    }

    public void keyPressed(KeyEvent event) {
        this.currentModeEventHandler.keyPressed(event);
    }

    public void keyReleased(KeyEvent event) {
        this.currentModeEventHandler.keyReleased(event);
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.currentModeEventHandler.mouseDoubleClick(event);
    }

    public void mouseDown(MouseEvent event) {
        this.currentModeEventHandler.mouseDown(event);
    }

    public void mouseUp(MouseEvent event) {
        this.currentModeEventHandler.mouseUp(event);
    }

    public void mouseMove(MouseEvent event) {
        this.currentModeEventHandler.mouseMove(event);
    }

    public void mouseEnter(MouseEvent e) {
        this.currentModeEventHandler.mouseEnter(e);
    }

    public void mouseExit(MouseEvent e) {
        this.currentModeEventHandler.mouseExit(e);
    }

    public void mouseHover(MouseEvent e) {
        this.currentModeEventHandler.mouseHover(e);
    }

    public void focusGained(FocusEvent event) {
        this.currentModeEventHandler.focusGained(event);
    }

    public void focusLost(FocusEvent event) {
        this.currentModeEventHandler.focusLost(event);
    }
}

