/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetFromCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetToCache;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.index.IAuxiliaryIndexCreator;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.AggrHolderManager;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.storage.DataSetStore;
import org.eclipse.birt.data.engine.storage.IDataSetUpdater;
import org.eclipse.birt.data.engine.storage.IDataSetWriter;

public class CachedResultSet
implements IResultIterator {
    protected ResultSetPopulator resultSetPopulator;
    protected IEventHandler handler;
    private ResultSet resultSet;
    private static String className = CachedResultSet.class.getName();
    private static Logger logger = Logger.getLogger(className);
    private AggrHolderManager aggrHolderManager = new AggrHolderManager();
    private IResultClass resultClass;

    public CachedResultSet() {
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, ResultSet odaResultSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IDataSetPopulator odaResultSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, DataSetToCache dataSetToCache, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        DataSetFromCache dsfc = this.resultSetPopulator.cacheDataSet(dataSetToCache);
        dataSetToCache.close();
        this.close();
        this.handler = eventHandler;
        this.aggrHolderManager = new AggrHolderManager();
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(dsfc));
        dsfc.close();
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, DataSetFromCache dataSetFromCache, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(dataSetFromCache));
        dataSetFromCache.close();
    }

    public CachedResultSet(BaseQuery query, ICustomDataSet customDataSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        assert (customDataSet != null);
        this.resultSetPopulator = new ResultSetPopulator(query, customDataSet.getResultClass(), this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(customDataSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IResultIterator parentResultIterator, int groupLevel, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        assert (parentResultIterator instanceof CachedResultSet);
        CachedResultSet parentResultSet = (CachedResultSet)parentResultIterator;
        int[] groupInfo = parentResultSet.getCurrentGroupInfo(groupLevel);
        this.resultSetPopulator = new ResultSetPopulator(query, this.createCustomDataSetMetaData(query, meta), this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(new Object[]{parentResultSet.resultSetPopulator.getCache(), groupInfo}));
    }

    private IResultClass createCustomDataSetMetaData(BaseQuery query, IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        if (query.getFetchEvents() != null) {
            int i = 0;
            while (i < meta.getFieldCount()) {
                ResultFieldMetadata rfMeta = new ResultFieldMetadata(i, meta.getFieldName(i + 1), meta.getFieldLabel(i + 1), meta.getFieldValueClass(i + 1), meta.getFieldNativeTypeName(i + 1), false, meta.getAnalysisType(i + 1), meta.getAnalysisColumn(i + 1), meta.isIndexColumn(i + 1), meta.isCompressedColumn(i + 1));
                rfMeta.setAlias(meta.getFieldAlias(i + 1));
                projectedColumns.add(rfMeta);
                ++i;
            }
            int j = 0;
            while (j < query.getFetchEvents().size()) {
                if (query.getFetchEvents().get(j) instanceof ComputedColumnHelper) {
                    ComputedColumnHelper helper = (ComputedColumnHelper)query.getFetchEvents().get(j);
                    helper.setModel(1);
                    int i2 = 0;
                    while (i2 < helper.getComputedColumnList().size()) {
                        projectedColumns.add(new ResultFieldMetadata(i2 + 1 + meta.getFieldCount(), ((IComputedColumn)helper.getComputedColumnList().get(i2)).getName(), ((IComputedColumn)helper.getComputedColumnList().get(i2)).getName(), DataType.getClass((int)((IComputedColumn)helper.getComputedColumnList().get(i2)).getDataType()), null, true, -1));
                        ++i2;
                    }
                }
                meta = new ResultClass(projectedColumns);
                ++j;
            }
        }
        return meta;
    }

    private int[] getCurrentGroupInfo(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getCurrentGroupInfo(groupLevel);
    }

    private List<IBinding> getRequestColumnMap() {
        try {
            if (DataSetStore.isDataMartStore(this.resultSetPopulator.getEventHandler().getAppContext(), this.resultSetPopulator.getSession())) {
                return null;
            }
        }
        catch (DataException dataException) {}
        return this.resultSetPopulator.getQuery().getQueryDefinition() != null && ((IQueryDefinition)this.resultSetPopulator.getQuery().getQueryDefinition()).needAutoBinding() ? null : this.resultSetPopulator.getEventHandler().getAllColumnBindings();
    }

    @Override
    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        if (streamsWrapper.getStreamForGroupInfo() != null) {
            this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().doSave(streamsWrapper.getStreamForGroupInfo());
        }
        if (!isSubQuery && !CachedResultSet.isSummaryQuery(this.resultSetPopulator.getQuery()) && streamsWrapper.getStreamForResultClass() != null) {
            ((ResultClass)this.populateResultClass(this.resultSetPopulator.getResultSetMetadata())).doSave(streamsWrapper.getStreamForResultClass(), this.getRequestColumnMap(), streamsWrapper.getStreamManager().getVersion());
            try {
                streamsWrapper.getStreamForResultClass().close();
                if (streamsWrapper.getStreamForDataSet() != null) {
                    Map<String, IIndexSerializer> index = streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext());
                    Map<String, StringTable> stringTables = streamsWrapper.getOutputStringTable(this.getResultClass());
                    IDataSetWriter writer = DataSetStore.createWriter(streamsWrapper.getStreamManager(), this.getResultClass(), this.handler.getAppContext(), this.resultSetPopulator.getSession(), streamsWrapper.getAuxiliaryIndexCreators());
                    if (writer != null) {
                        writer.save(this.resultSetPopulator.getCache());
                        writer.close();
                    } else {
                        for (IAuxiliaryIndexCreator aIndex : streamsWrapper.getAuxiliaryIndexCreators()) {
                            aIndex.initialize(this.resultClass, this.getExecutorHelper().getScriptable());
                        }
                        this.resultSetPopulator.getCache().doSave(streamsWrapper.getStreamForDataSet(), streamsWrapper.getStreamForDataSetRowLens(), stringTables, index, this.resultSetPopulator.getEventHandler().getAllColumnBindings(), streamsWrapper.getStreamManager().getVersion(), streamsWrapper.getAuxiliaryIndexCreators(), false);
                        for (StringTable stringTable : stringTables.values()) {
                            stringTable.close();
                        }
                        for (IIndexSerializer ind : index.values()) {
                            ind.close();
                        }
                    }
                    for (IAuxiliaryIndexCreator creator : streamsWrapper.getAuxiliaryIndexCreators()) {
                        creator.close();
                    }
                }
                streamsWrapper.getStreamForDataSet().close();
                streamsWrapper.getStreamForDataSetRowLens().close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (streamsWrapper.getStreamManager().getVersion() >= 110 && !this.aggrHolderManager.isEmpty()) {
            this.aggrHolderManager.doSave(streamsWrapper.getStreamManager().getOutStream(103, 0, 0), streamsWrapper.getStreamManager().getOutStream(104, 0, 0));
        }
    }

    private IResultClass populateResultClass(IResultClass meta) throws DataException {
        if (this.resultClass == null) {
            ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
            int i = 1;
            while (i <= meta.getFieldCount()) {
                if (!meta.getFieldName(i).equals("_$$_dte_inner_row_id_$$_")) {
                    list.add(meta.getFieldMetaData(i));
                }
                ++i;
            }
            this.resultClass = new ResultClass(list);
        }
        return this.resultClass;
    }

    private static boolean isSummaryQuery(BaseQuery query) {
        return query.getQueryDefinition() != null && ((IQueryDefinition)query.getQueryDefinition()).isSummaryQuery();
    }

    @Override
    public void close() throws DataException {
        if (this.resultSetPopulator == null || this.resultSetPopulator.getCache() == null) {
            return;
        }
        this.resultSetPopulator.getCache().close();
        this.resultSetPopulator = null;
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (DataException e) {
            logger.logp(Level.FINE, className, "closeOdaResultSet", "Exception at CachedResultSet.close()", (Throwable)((Object)e));
        }
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        return this.resultSetPopulator.getCache().getCurrentResult();
    }

    @Override
    public boolean next() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        boolean hasNext = this.resultSetPopulator.getCache().next();
        this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().next(hasNext);
        return hasNext;
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        return this.resultSetPopulator.getEndingGroupLevel();
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        return this.resultSetPopulator.getStartingGroupLevel();
    }

    @Override
    public void first(int groupLevel) throws DataException {
        this.resultSetPopulator.first(groupLevel);
    }

    @Override
    public void last(int groupLevel) throws DataException {
        this.resultSetPopulator.last(groupLevel);
    }

    @Override
    public IResultClass getResultClass() throws DataException {
        return this.resultSetPopulator.getResultSetMetadata();
    }

    @Override
    public int getCurrentResultIndex() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        return this.resultSetPopulator.getCache().getCurrentIndex();
    }

    @Override
    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getCurrentGroupIndex(groupLevel);
    }

    @Override
    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupStartAndEndIndex(groupLevel);
    }

    @Override
    public int getRowCount() throws DataException {
        return this.resultSetPopulator.getCache().getCount();
    }

    @Override
    public ResultSetCache getResultSetCache() {
        return this.resultSetPopulator.getCache();
    }

    @Override
    public IExecutorHelper getExecutorHelper() {
        if (this.handler != null) {
            return this.handler.getExecutorHelper();
        }
        return null;
    }

    public void setOdaResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public Object getAggrValue(String aggrName) throws DataException {
        return this.aggrHolderManager.getAggrValue(aggrName);
    }

    public void addAggrValueHolder(IAggrValueHolder holder) throws DataException {
        this.aggrHolderManager.addAggrValueHolder(holder);
    }

    public List<IAggrValueHolder> getAggrValueHolders() {
        return this.aggrHolderManager.getAggrValueHolders();
    }

    public void clearAggrValueHolder() throws DataException {
        this.aggrHolderManager.clear();
    }

    @Override
    public void incrementalUpdate(StreamWrapper streamsWrapper, int originalRowCount, boolean isSubQuery) throws DataException {
        if (!isSubQuery && !CachedResultSet.isSummaryQuery(this.resultSetPopulator.getQuery()) && streamsWrapper.getStreamForResultClass() != null) {
            IDataSetUpdater updater = DataSetStore.createUpdater(streamsWrapper.getStreamManager(), this.getResultClass(), this.handler.getAppContext(), this.resultSetPopulator.getSession(), streamsWrapper.getAuxiliaryIndexCreators());
            if (updater != null) {
                updater.save(this.resultSetPopulator.getCache());
                updater.close();
                return;
            }
            try {
                OutputStream outputStream = streamsWrapper.getStreamManager().getOutStream(21, 0, 2);
                OutputStream dlStream = streamsWrapper.getStreamManager().getOutStream(23, 0, 2);
                if (outputStream != null) {
                    Map<String, IIndexSerializer> index = streamsWrapper.getStreamForIndex(this.getResultClass(), this.handler.getAppContext());
                    Map<String, StringTable> stringTables = streamsWrapper.getOutputStringTable(this.getResultClass());
                    this.resultSetPopulator.getCache().incrementalUpdate(outputStream, dlStream, originalRowCount, stringTables, index, this.resultSetPopulator.getEventHandler().getAllColumnBindings(), streamsWrapper.getStreamManager().getVersion(), streamsWrapper.getAuxiliaryIndexCreators());
                    for (StringTable stringTable : stringTables.values()) {
                        stringTable.close();
                    }
                    for (IIndexSerializer ind : index.values()) {
                        ind.close();
                    }
                    for (IAuxiliaryIndexCreator creator : streamsWrapper.getAuxiliaryIndexCreators()) {
                        creator.close();
                    }
                    outputStream.close();
                    dlStream.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }
}

