/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationRowAccessor;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AggregationResultSetWithOneMoreBindingFetcher
implements IAggregationResultSet {
    private static Logger logger = Logger.getLogger(AggregationResultSetWithOneMoreBindingFetcher.class.getName());
    private IAggregationResultSet ars;
    private String addedAggrName;
    private IBaseExpression addedAggrExpression;
    private Scriptable scope;
    private ScriptContext cx;

    public AggregationResultSetWithOneMoreBindingFetcher(IAggregationResultSet aggregationResultSet, String addedAggrName, IBaseExpression addedAggrExpression, IBindingValueFetcher fetcher, Scriptable scope, ScriptContext cx) {
        this.ars = aggregationResultSet;
        this.addedAggrName = addedAggrName;
        this.addedAggrExpression = addedAggrExpression;
        this.scope = scope;
        this.cx = cx;
        this.scope.put("data", this.scope, (Object)new JSDataObject(fetcher));
        this.scope.put("row", this.scope, (Object)new JSDataObject(fetcher));
        this.scope.put("dimension", this.scope, (Object)new JSDimensionObject());
    }

    @Override
    public void clear() throws IOException {
        this.ars.clear();
    }

    @Override
    public void close() throws IOException {
        this.ars.close();
    }

    @Override
    public int getAggregationCount() {
        return this.ars.getAggregationCount() + 1;
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        return this.getAggregationDataType()[aggregationIndex];
    }

    @Override
    public int[] getAggregationDataType() {
        int[] types = new int[this.ars.getAggregationCount() + 1];
        System.arraycopy(this.ars.getAggregationDataType(), 0, types, 0, this.ars.getAggregationDataType().length);
        types[types.length - 1] = this.addedAggrExpression.getDataType();
        return types;
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return this.ars.getAggregationDefinition();
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        int index = this.ars.getAggregationIndex(name);
        if (index < 0) {
            if (this.addedAggrName.equals(name)) {
                return this.getAggregationCount() - 1;
            }
            return -1;
        }
        return index;
    }

    @Override
    public String getAggregationName(int index) {
        if (index == this.getAggregationCount() - 1) {
            return this.addedAggrName;
        }
        return this.ars.getAggregationName(index);
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (aggregationIndex == this.getAggregationCount() - 1) {
            try {
                return ScriptEvalUtil.evalExpr(this.addedAggrExpression, this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
            }
            catch (DataException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)((Object)e));
                throw new IOException(e.getLocalizedMessage());
            }
        }
        return this.ars.getAggregationValue(aggregationIndex);
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.ars.getAllLevels();
    }

    @Override
    public String[][] getAttributeNames() {
        return this.ars.getAttributeNames();
    }

    @Override
    public IAggregationResultRow getCurrentRow() throws IOException {
        IAggregationResultRow arr = this.ars.getCurrentRow();
        Object[] values1 = arr.getAggregationValues();
        Object[] values = new Object[values1.length + 1];
        System.arraycopy(values1, 0, values, 0, values1.length);
        values[values.length - 1] = this.getAggregationValue(this.getAggregationCount() - 1);
        AggregationResultRow result = new AggregationResultRow();
        result.setLevelMembers(arr.getLevelMembers());
        result.setAggregationValues(values);
        return result;
    }

    @Override
    public String[][] getKeyNames() {
        return this.ars.getKeyNames();
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.ars.getLevel(levelIndex);
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        return this.ars.getLevelAttribute(levelIndex, attributeIndex);
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        return this.ars.getLevelAttributeColCount(levelIndex);
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        return this.ars.getLevelAttributeDataType(level, attributeName);
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        return this.ars.getLevelAttributeDataType(levelIndex, attributeName);
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.ars.getLevelAttributeDataType();
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        return this.ars.getLevelAttributeIndex(levelIndex, attributeName);
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        return this.ars.getLevelAttributeIndex(level, attributeName);
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        return this.ars.getLevelAttributes(levelIndex);
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.ars.getLevelAttributes();
    }

    @Override
    public int getLevelCount() {
        return this.ars.getLevelCount();
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        return this.ars.getLevelIndex(level);
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        return this.ars.getLevelKeyColCount(levelIndex);
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        return this.ars.getLevelKeyDataType(level, keyName);
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        return this.ars.getLevelKeyDataType(levelIndex, keyName);
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.ars.getLevelKeyDataType();
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        return this.ars.getLevelKeyIndex(levelIndex, keyName);
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        return this.ars.getLevelKeyIndex(level, keyName);
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.ars.getLevelKeyName(levelIndex, keyIndex);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        return this.ars.getLevelKeyValue(levelIndex);
    }

    @Override
    public String[][] getLevelKeys() {
        return this.ars.getLevelKeys();
    }

    @Override
    public int getPosition() {
        return this.ars.getPosition();
    }

    @Override
    public int getSortType(int levelIndex) {
        return this.ars.getSortType(levelIndex);
    }

    @Override
    public int[] getSortType() {
        return this.ars.getSortType();
    }

    @Override
    public int length() {
        return this.ars.length();
    }

    @Override
    public void seek(int index) throws IOException {
        this.ars.seek(index);
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        return this.ars.getLevelAttributesValue(levelIndex);
    }

    private class JSDataObject
    extends ScriptableObject {
        private IBindingValueFetcher fetcher;
        private AggregationRowAccessor accessor;

        public JSDataObject(IBindingValueFetcher fetcher) {
            this.fetcher = fetcher;
            this.accessor = new AggregationRowAccessor(AggregationResultSetWithOneMoreBindingFetcher.this.ars, fetcher);
        }

        public Object get(String arg0, Scriptable scope) {
            try {
                int index = AggregationResultSetWithOneMoreBindingFetcher.this.ars.getAggregationIndex(arg0);
                if (index < 0) {
                    try {
                        return this.fetcher.getValue(arg0, this.accessor, AggregationResultSetWithOneMoreBindingFetcher.this.ars.getPosition());
                    }
                    catch (DataException dataException) {
                        throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
                    }
                }
                return AggregationResultSetWithOneMoreBindingFetcher.this.ars.getAggregationValue(index);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                throw Context.reportRuntimeError((String)e.getLocalizedMessage());
            }
        }

        public String getClassName() {
            return JSDataObject.class.getName();
        }
    }

    private class JSDimensionObject
    extends ScriptableObject {
        private JSDimensionObject() {
        }

        public Object get(String name, Scriptable start) {
            return new JSLevelObject(name);
        }

        public String getClassName() {
            return JSDimensionObject.class.getName();
        }
    }

    private class JSLevelObject
    extends ScriptableObject {
        private String dimensionName;

        public JSLevelObject(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public Object get(String name, Scriptable start) {
            int levelIndex = AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelIndex(new DimLevel(this.dimensionName, name));
            if (levelIndex < 0) {
                throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
            }
            return new JSMemberObject(levelIndex);
        }

        public String getClassName() {
            return JSLevelObject.class.getName();
        }
    }

    private class JSMemberObject
    extends ScriptableObject {
        private int levelIndex;

        public JSMemberObject(int levelIndex) {
            this.levelIndex = levelIndex;
        }

        public Object getDefaultValue(Class typeHint) {
            return AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelKeyValue(this.levelIndex)[0];
        }

        public Object get(String name, Scriptable start) {
            int keyIndex = AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelKeyIndex(this.levelIndex, name);
            if (keyIndex >= 0) {
                return AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelKeyValue(this.levelIndex)[keyIndex];
            }
            int attrIndex = AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelAttributeIndex(keyIndex, name);
            if (attrIndex < 0) {
                throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
            }
            return AggregationResultSetWithOneMoreBindingFetcher.this.ars.getLevelAttribute(this.levelIndex, attrIndex);
        }

        public String getClassName() {
            return JSMemberObject.class.getName();
        }
    }
}

