/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.IPeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.PeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabases;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.exceptions.NoQuantitationTableAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.calculator.QuantitationCalculatorMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationEntryMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakQuantitationCalculatorESTD {
    private static final Logger logger = Logger.getLogger(PeakQuantitationCalculatorESTD.class);

    public IPeakQuantifierProcessingInfo quantify(List<IPeakMSD> peaks, IPeakQuantifierSettings peakQuantifierSettings, IProgressMonitor monitor) {
        PeakQuantifierProcessingInfo processingInfo = new PeakQuantifierProcessingInfo();
        try {
            IQuantDatabase database = QuantDatabases.getQuantDatabase();
            QuantitationCalculatorMSD calculator = new QuantitationCalculatorMSD();
            List<IQuantitationCompoundMSD> quantitationCompounds = database.getQuantitationCompounds();
            for (IPeakMSD peakMSD : peaks) {
                List<IQuantitationCompoundMSD> quantitationCompoundsMSD = this.getQuantitationEntries(quantitationCompounds, peakMSD);
                List<IQuantitationEntryMSD> entries = calculator.calculateQuantitationResults(peakMSD, quantitationCompoundsMSD, (IPeakQuantifierProcessingInfo)processingInfo);
                for (IQuantitationEntryMSD quantitationEntry : entries) {
                    peakMSD.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
                }
            }
        }
        catch (NoQuantitationTableAvailableException e) {
            processingInfo.addErrorMessage("ChemClipse Quantitation", "Please select a quantitation table.");
            logger.warn((Object)e);
        }
        return processingInfo;
    }

    private List<IQuantitationCompoundMSD> getQuantitationEntries(List<IQuantitationCompoundMSD> quantitationCompounds, IPeakMSD peakMSD) {
        ArrayList<IQuantitationCompoundMSD> quantitationCompoundsMSD = new ArrayList<IQuantitationCompoundMSD>();
        for (IQuantitationCompoundMSD quantitationCompound : quantitationCompounds) {
            int retentionTime = peakMSD.getPeakModel().getRetentionTimeAtPeakMaximum();
            IRetentionTimeWindow retentionTimeWindow = quantitationCompound.getRetentionTimeWindow();
            if (!retentionTimeWindow.isRetentionTimeInWindow(retentionTime)) continue;
            quantitationCompoundsMSD.add(quantitationCompound);
        }
        return quantitationCompoundsMSD;
    }
}

