/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.IPeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.processing.PeakQuantifierProcessingInfo;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationEntryMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakQuantitationCalculatorISTD {
    public IPeakQuantifierProcessingInfo quantifySelectedPeak(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        PeakQuantifierProcessingInfo processingInfo = new PeakQuantifierProcessingInfo();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        List<? extends IPeak> internalStandardPeaks = this.getInternalStandardPeaks(chromatogram);
        IPeak peakToQuantify = chromatogramSelection.getSelectedPeak();
        this.quantifyPeak(internalStandardPeaks, peakToQuantify);
        return processingInfo;
    }

    public IPeakQuantifierProcessingInfo quantifyAllPeaks(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        PeakQuantifierProcessingInfo processingInfo = new PeakQuantifierProcessingInfo();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        List<? extends IPeak> internalStandardPeaks = this.getInternalStandardPeaks(chromatogram);
        List<IPeak> peaksToQuantify = this.getPeaksToQuantify(chromatogramSelection);
        for (IPeak peakToQuantify : peaksToQuantify) {
            this.quantifyPeak(internalStandardPeaks, peakToQuantify);
        }
        return processingInfo;
    }

    private void quantifyPeak(List<? extends IPeak> internalStandardPeaks, IPeak peakToQuantify) {
        for (IPeak iPeak : internalStandardPeaks) {
            double peakAreaISTD = iPeak.getIntegratedArea();
            if (!(peakAreaISTD > 0.0)) continue;
            for (IInternalStandard internalStandard : iPeak.getInternalStandards()) {
                String name = internalStandard.getName();
                double concentration = internalStandard.getConcentration();
                String concentrationUnit = internalStandard.getConcentrationUnit();
                double responseFactor = internalStandard.getResponseFactor();
                String chemicalClass = internalStandard.getChemicalClass();
                double integratedArea = peakToQuantify.getIntegratedArea();
                double concentrationCalculated = concentration / peakAreaISTD * integratedArea * responseFactor;
                if (peakToQuantify instanceof IChromatogramPeakMSD) {
                    QuantitationEntryMSD quantitationEntryMSD = new QuantitationEntryMSD(name, concentrationCalculated, concentrationUnit, integratedArea, 0.0);
                    quantitationEntryMSD.setCalibrationMethod(CalibrationMethod.ISTD.toString());
                    quantitationEntryMSD.setUsedCrossZero(false);
                    quantitationEntryMSD.setChemicalClass(chemicalClass);
                    peakToQuantify.addQuantitationEntry((IQuantitationEntry)quantitationEntryMSD);
                    continue;
                }
                if (!(peakToQuantify instanceof IChromatogramPeakCSD)) continue;
                QuantitationEntry quantitationEntry = new QuantitationEntry(name, concentrationCalculated, concentrationUnit, integratedArea);
                quantitationEntry.setCalibrationMethod(CalibrationMethod.ISTD.toString());
                quantitationEntry.setUsedCrossZero(false);
                quantitationEntry.setChemicalClass(chemicalClass);
                peakToQuantify.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
            }
        }
    }

    private List<? extends IPeak> getInternalStandardPeaks(IChromatogram chromatogram) {
        if (chromatogram != null) {
            if (chromatogram instanceof IChromatogramMSD) {
                ArrayList<IChromatogramPeakMSD> internalStandardPeaks = new ArrayList<IChromatogramPeakMSD>();
                IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogram;
                for (IChromatogramPeakMSD peak : chromatogramMSD.getPeaks()) {
                    if (peak.getInternalStandards().size() <= 0) continue;
                    internalStandardPeaks.add(peak);
                }
                return internalStandardPeaks;
            }
            if (chromatogram instanceof IChromatogramCSD) {
                ArrayList<IChromatogramPeakCSD> internalStandardPeaks = new ArrayList<IChromatogramPeakCSD>();
                IChromatogramCSD chromatogramCSD = (IChromatogramCSD)chromatogram;
                for (IChromatogramPeakCSD peak : chromatogramCSD.getPeaks()) {
                    if (peak.getInternalStandards().size() <= 0) continue;
                    internalStandardPeaks.add(peak);
                }
                return internalStandardPeaks;
            }
        }
        return new ArrayList();
    }

    private List<IPeak> getPeaksToQuantify(IChromatogramSelection chromatogramSelection) {
        ArrayList<IPeak> peaksToQuantify;
        block3: {
            block2: {
                peaksToQuantify = new ArrayList<IPeak>();
                if (!(chromatogramSelection instanceof IChromatogramSelectionMSD)) break block2;
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                for (IChromatogramPeakMSD peak : chromatogramSelectionMSD.getChromatogramMSD().getPeaks(chromatogramSelectionMSD)) {
                    peaksToQuantify.add((IPeak)peak);
                }
                break block3;
            }
            if (!(chromatogramSelection instanceof IChromatogramSelectionCSD)) break block3;
            IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
            for (IChromatogramPeakCSD peak : chromatogramSelectionCSD.getChromatogramCSD().getPeaks(chromatogramSelectionCSD)) {
                peaksToQuantify.add((IPeak)peak);
            }
        }
        return peaksToQuantify;
    }
}

