/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.support;

import java.util.ArrayList;
import java.util.List;

public class FileExtensionCompiler {
    private static final String SELECT_ALL = "*";
    private List<String> extensions;

    public FileExtensionCompiler(String extension, boolean useLowerAndUpperCase) {
        if (extension == null) {
            extension = "";
        }
        this.extensions = new ArrayList<String>();
        this.addExtension(extension);
        if (useLowerAndUpperCase) {
            this.addExtension(extension.toLowerCase());
            this.addExtension(extension.toUpperCase());
        }
    }

    public String getCompiledFileExtension() {
        StringBuilder builder = new StringBuilder();
        int last = this.extensions.size() - 1;
        int index = 0;
        while (index < last) {
            builder.append(SELECT_ALL);
            builder.append(this.extensions.get(index));
            builder.append(";");
            ++index;
        }
        builder.append(SELECT_ALL);
        builder.append(this.extensions.get(last));
        return builder.toString();
    }

    private void addExtension(String extension) {
        if (!this.extensions.contains(extension)) {
            this.extensions.add(extension);
        }
    }
}

