/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.core;

import org.eclipse.chemclipse.chromatogram.msd.classifier.core.ChromatogramClassifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.ChromatogramClassifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.core.IChromatogramClassifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.ChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.processing.IChromatogramClassifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.classifier.settings.IChromatogramClassifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ChromatogramClassifier {
    private static final Logger logger = Logger.getLogger(ChromatogramClassifier.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.classifier.chromatogramClassifierSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String CLASSIFIER_NAME = "classifierName";
    private static final String CLASSIFIER = "classifier";
    private static final String NO_CHROMATOGRAM_CLASSIFIER_AVAILABLE = "There is no chromatogram classifier available.";

    private ChromatogramClassifier() {
    }

    public static IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, IChromatogramClassifierSettings chromatogramClassifierSettings, String classifierId, IProgressMonitor monitor) {
        IChromatogramClassifier chromatogramClassifier = ChromatogramClassifier.getChromatogramClassifier(classifierId);
        IChromatogramClassifierProcessingInfo processingInfo = chromatogramClassifier != null ? chromatogramClassifier.applyClassifier(chromatogramSelection, chromatogramClassifierSettings, monitor) : ChromatogramClassifier.getNoClassifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IChromatogramClassifierProcessingInfo applyClassifier(IChromatogramSelectionMSD chromatogramSelection, String classifierId, IProgressMonitor monitor) {
        IChromatogramClassifier chromatogramClassifier = ChromatogramClassifier.getChromatogramClassifier(classifierId);
        IChromatogramClassifierProcessingInfo processingInfo = chromatogramClassifier != null ? chromatogramClassifier.applyClassifier(chromatogramSelection, monitor) : ChromatogramClassifier.getNoClassifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IChromatogramClassifierSupport getChromatogramClassifierSupport() {
        IConfigurationElement[] extensions;
        ChromatogramClassifierSupport classifierSupport = new ChromatogramClassifierSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ChromatogramClassifierSupplier supplier = new ChromatogramClassifierSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setClassifierName(element.getAttribute(CLASSIFIER_NAME));
            classifierSupport.add(supplier);
            ++n2;
        }
        return classifierSupport;
    }

    private static IChromatogramClassifier getChromatogramClassifier(String classifierId) {
        IConfigurationElement element = ChromatogramClassifier.getConfigurationElement(classifierId);
        IChromatogramClassifier instance = null;
        if (element != null) {
            try {
                instance = (IChromatogramClassifier)element.createExecutableExtension(CLASSIFIER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String classifierId) {
        IConfigurationElement[] elements;
        if ("".equals(classifierId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(classifierId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IChromatogramClassifierProcessingInfo getNoClassifierAvailableProcessingInfo() {
        ChromatogramClassifierProcessingInfo processingInfo = new ChromatogramClassifierProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Chromatogram Classifier", NO_CHROMATOGRAM_CLASSIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

