/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JavaElementHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IJavaElement fElement;
    private final boolean fQualify;

    public JavaElementHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, boolean qualify) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fElement = element;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.fElement != null) {
            this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)this.fElement));
        } else {
            this.fOpenAction.run((ITextSelection)new TextSelection(this.fRegion.getOffset(), this.fRegion.getLength()));
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify && this.fElement != null) {
            String elementLabel = JavaElementLabels.getElementLabel(this.fElement, JavaElementLabels.ALL_POST_QUALIFIED);
            return Messages.format(JavaEditorMessages.JavaElementHyperlink_hyperlinkText_qualified, new Object[]{elementLabel});
        }
        return JavaEditorMessages.JavaElementHyperlink_hyperlinkText;
    }
}

