/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.Activator;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.FirstDerivativePeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.FirstDerivativePeakDetectorMSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.IFirstDerivativePeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.IFirstDerivativePeakDetectorMSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.Threshold;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String P_THRESHOLD = "threshold";
    public static final String DEF_THRESHOLD = Threshold.MEDIUM.toString();
    public static final String P_INCLUDE_BACKGROUND = "includeBackground";
    public static final boolean DEF_INCLUDE_BACKGROUND = false;
    public static final String P_MIN_SN_RATIO = "minSNRatio";
    public static final float DEF_MIN_SN_RATIO = 0.0f;
    public static final String P_MOVING_AVERAGE_WINDOW_SIZE = "movingAverageWindowSize";
    public static final String DEF_MOVING_AVERAGE_WINDOW_SIZE = WindowSize.SCANS_3.toString();
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        defaultValues.put(P_INCLUDE_BACKGROUND, Boolean.toString(false));
        defaultValues.put(P_MIN_SN_RATIO, Float.toString(0.0f));
        defaultValues.put(P_MOVING_AVERAGE_WINDOW_SIZE, DEF_MOVING_AVERAGE_WINDOW_SIZE);
        defaultValues.put(P_THRESHOLD, DEF_THRESHOLD);
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static IFirstDerivativePeakDetectorMSDSettings getPeakDetectorMSDSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        FirstDerivativePeakDetectorMSDSettings peakDetectorSettings = new FirstDerivativePeakDetectorMSDSettings();
        peakDetectorSettings.setThreshold(Threshold.valueOf(preferences.get(P_THRESHOLD, DEF_THRESHOLD)));
        peakDetectorSettings.setIncludeBackground(preferences.getBoolean(P_INCLUDE_BACKGROUND, false));
        peakDetectorSettings.setMinimumSignalToNoiseRatio(preferences.getFloat(P_MIN_SN_RATIO, 0.0f));
        peakDetectorSettings.setMovingAverageWindowSize(PreferenceSupplier.getMovingAverageWindowSize());
        return peakDetectorSettings;
    }

    public static IFirstDerivativePeakDetectorCSDSettings getPeakDetectorCSDSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        FirstDerivativePeakDetectorCSDSettings peakDetectorSettings = new FirstDerivativePeakDetectorCSDSettings();
        peakDetectorSettings.setThreshold(Threshold.valueOf(preferences.get(P_THRESHOLD, DEF_THRESHOLD)));
        peakDetectorSettings.setIncludeBackground(preferences.getBoolean(P_INCLUDE_BACKGROUND, false));
        peakDetectorSettings.setMinimumSignalToNoiseRatio(preferences.getFloat(P_MIN_SN_RATIO, 0.0f));
        peakDetectorSettings.setMovingAverageWindowSize(PreferenceSupplier.getMovingAverageWindowSize());
        return peakDetectorSettings;
    }

    public static WindowSize getMovingAverageWindowSize() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String size = preferences.get(P_MOVING_AVERAGE_WINDOW_SIZE, DEF_MOVING_AVERAGE_WINDOW_SIZE);
        return WindowSize.valueOf((String)size);
    }

    public static Threshold getThreshold() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        String threshold = preferences.get(P_THRESHOLD, DEF_THRESHOLD);
        if (threshold.equals("")) {
            threshold = Threshold.OFF.toString();
        }
        return Threshold.valueOf(threshold);
    }

    public static boolean isIncludeBackground() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getBoolean(P_INCLUDE_BACKGROUND, false);
    }

    public static float getMinimumSignalToNoiseRatio() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.getFloat(P_MIN_SN_RATIO, 0.0f);
    }
}

