/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram;

import java.util.ArrayList;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.swt.ui.components.chromatogram.AbstractViewWSDChromatogramUI;
import org.eclipse.chemclipse.wsd.swt.ui.converter.SeriesConverterWSD;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class SelectedWavelengthChromatogramUI
extends AbstractViewWSDChromatogramUI {
    public SelectedWavelengthChromatogramUI(Composite parent, int style) {
        super(parent, style);
    }

    public void setViewSeries() {
        IChromatogramSelection storedChromatogramSelection = this.getChromatogramSelection();
        if (storedChromatogramSelection instanceof IChromatogramSelectionWSD) {
            IChromatogramSelectionWSD chromatogramSelection = (IChromatogramSelectionWSD)storedChromatogramSelection;
            ArrayList<Integer> wavelengths = new ArrayList<Integer>(chromatogramSelection.getSelectedWavelengths().getWavelengths());
            IMultipleSeries multipleSeries = SeriesConverterWSD.convertChromatogram(chromatogramSelection, wavelengths, false, Sign.POSITIVE);
            int size = multipleSeries.getMultipleSeries().size();
            String colorSchemeOverlay = PreferenceSupplier.getColorSchemeOverlay();
            IColorScheme colorScheme = Colors.getColorScheme((String)colorSchemeOverlay);
            int i = 0;
            while (i < size) {
                ISeries series = (ISeries)multipleSeries.getMultipleSeries().get(i);
                this.setAdditionalIonSeries(series, colorScheme.getColor());
                colorScheme.incrementColor();
                ++i;
            }
        }
    }

    private void setAdditionalIonSeries(ISeries series, Color color) {
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(color);
    }
}

