/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.chemclipse.ux.extension.ui.Activator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WelcomeView {
    private static final String CSS_ID = "org-eclipse-chemclipse-ux-extension-ui-views-welcomeview-background";
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private IEventBroker eventBroker;
    private Button buttonMSDPerspective;

    @Inject
    public WelcomeView(Composite parent) {
        this.initializeContent(parent);
    }

    @Focus
    public void setFocus() {
        this.buttonMSDPerspective.setFocus();
    }

    private void initializeContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridLayout(1, true));
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        final Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setData("org.eclipse.e4.ui.css.id", (Object)CSS_ID);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        composite.setLayoutData((Object)gridData);
        this.createContent(composite);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle rectangle = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(composite.computeSize(rectangle.width, -1));
            }
        });
    }

    private void createContent(Composite parent) {
        parent.setBackgroundMode(2);
        this.createWelcomeText(parent);
        this.createPerspectivesInfo(parent);
        this.createRunDemoButton(parent);
        this.createInfo(parent);
        this.createPerspectivesLaunchButtons(parent);
        this.createAdditionalInfo(parent);
        this.createLibraryAndPeaksPerspectiveButtons(parent);
        this.createContactLink(parent);
    }

    private void createWelcomeText(Composite parent) {
        Font welcomeFont = new Font((Device)Display.getCurrent(), "Arial", 18, 1);
        Label welcome = new Label(parent, 0x1000000);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.verticalIndent = 50;
        welcome.setLayoutData((Object)gridData);
        welcome.setFont(welcomeFont);
        Properties properties = System.getProperties();
        Object object = properties.get("application.name");
        String welcomeMessage = "Welcome";
        if (object instanceof String) {
            welcomeMessage = (String)object;
            welcomeMessage = welcomeMessage == null || welcomeMessage.equals("") ? "Welcome" : welcomeMessage.replaceAll("_", " ");
        }
        welcome.setText(welcomeMessage);
        welcomeFont.dispose();
    }

    private void createPerspectivesInfo(Composite parent) {
        Image image = Activator.getDefault().getImageRegistry().get("Perspectives");
        Composite logo = new Composite(parent, 0);
        GridData gridData = new GridData(0x1000000, 128, true, false);
        gridData.verticalIndent = 30;
        gridData.verticalAlignment = 1;
        gridData.widthHint = image.getBounds().width;
        gridData.heightHint = image.getBounds().height;
        logo.setLayoutData((Object)gridData);
        logo.setBackgroundImage(image);
        Label welcome = new Label(parent, 0x1000000);
        gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.verticalIndent = 10;
        welcome.setLayoutData((Object)gridData);
        welcome.setText("Use the toolbar to (1) Install Plug-ins (2) Fetch Updates (3) Switch Perspectives (4) Open Views");
    }

    private void createRunDemoButton(Composite parent) {
        Button buttonDemo = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.verticalIndent = 30;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        buttonDemo.setLayoutData((Object)gridData);
        buttonDemo.setText("Run Demo");
        buttonDemo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks");
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URL url = new URL(Platform.getInstallLocation().getURL() + "DemoChromatogram.ocb");
                            File file = new File(url.getFile());
                            if (file.exists()) {
                                MPartStack partStack = (MPartStack)WelcomeView.this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)WelcomeView.this.application);
                                MInputPart part = MBasicFactory.INSTANCE.createInputPart();
                                part.setElementId("org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor");
                                part.setContributionURI("bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD");
                                part.setObject((Object)file.getAbsolutePath());
                                part.setIconURI("platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif");
                                part.setLabel(file.getName());
                                part.setTooltip("Chromatogram - Detector Type: MSD");
                                part.setCloseable(true);
                                partStack.getChildren().add(part);
                                WelcomeView.this.partService.showPart((MPart)part, EPartService.PartState.ACTIVATE);
                            }
                        }
                        catch (MalformedURLException e) {
                            System.out.println(e);
                        }
                    }
                });
            }
        });
    }

    private void createInfo(Composite parent) {
        Label info1 = new Label(parent, 0x1000040);
        GridData gridData = new GridData(0x1000000, 128, true, false);
        gridData.verticalIndent = 10;
        gridData.verticalAlignment = 1;
        info1.setLayoutData((Object)gridData);
        info1.setText("The flexible open source solution for chromatography and mass spectrometry.\r\nIt offers a variety of solutions to analyze chromatographic data.\r\nSo far, the main focus is on mass spectrometric data (MSD).");
    }

    private void createPerspectivesLaunchButtons(Composite parent) {
        this.buttonMSDPerspective = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        gridData.verticalIndent = 10;
        this.buttonMSDPerspective.setLayoutData((Object)gridData);
        this.buttonMSDPerspective.setText("MSD Perspective (MS, MS/MS, ...)");
        this.buttonMSDPerspective.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.main");
            }
        });
        Button buttonCSDPerspective = new Button(parent, 8);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        buttonCSDPerspective.setLayoutData((Object)gridData);
        buttonCSDPerspective.setText("CSD Perspective (FID, ECD, ...)");
        buttonCSDPerspective.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.ux.extension.csd.ui.perspective.main");
            }
        });
        Button buttonWSDPerspective = new Button(parent, 8);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        buttonWSDPerspective.setLayoutData((Object)gridData);
        buttonWSDPerspective.setText("WSD Perspective (UV/Vis, DAD, ...)");
        buttonWSDPerspective.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.ux.extension.wsd.ui.perspective.main");
            }
        });
    }

    private void createAdditionalInfo(Composite parent) {
        Label info = new Label(parent, 0x1000040);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.verticalIndent = 50;
        info.setLayoutData((Object)gridData);
        info.setText("Several perspectives are offered, focused on different tasks.");
    }

    private void createLibraryAndPeaksPerspectiveButtons(Composite parent) {
        Button buttonSetLibraryPerspective = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        gridData.verticalIndent = 20;
        buttonSetLibraryPerspective.setLayoutData((Object)gridData);
        buttonSetLibraryPerspective.setText("Mass Spectrum / Library Perspective");
        buttonSetLibraryPerspective.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.ux.extension.msd.ui.perspective.massSpectrumLibrary");
            }
        });
        Button buttonSetPeaksPerspective = new Button(parent, 8);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 2;
        buttonSetPeaksPerspective.setLayoutData((Object)gridData);
        buttonSetPeaksPerspective.setText("Peaks Perspective (MSD)");
        buttonSetPeaksPerspective.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WelcomeView.this.switchPerspective("org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks");
            }
        });
    }

    private void createContactLink(Composite parent) {
        Label info = new Label(parent, 0x1000040);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.verticalIndent = 50;
        info.setLayoutData((Object)gridData);
        info.setText("If you have questions, don't hesitate to contact us.");
    }

    private void switchPerspective(String perspectiveId) {
        MUIElement element = this.modelService.find(perspectiveId, (MUIElement)this.application);
        if (element instanceof MPerspective) {
            MPerspective perspective = (MPerspective)element;
            this.partService.switchPerspective(perspective);
            if (this.eventBroker != null) {
                this.eventBroker.send("application/select/perspective", (Object)perspective.getLabel());
            }
        }
    }
}

